/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.GrowthType;
import software.amazon.awssdk.services.appconfig.model.ReplicateTo;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentStrategyRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, CreateDeploymentStrategyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::name)).setter(CreateDeploymentStrategyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::description)).setter(CreateDeploymentStrategyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentDurationInMinutes").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::deploymentDurationInMinutes)).setter(CreateDeploymentStrategyRequest.setter(Builder::deploymentDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes").build()}).build();
    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FinalBakeTimeInMinutes").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::finalBakeTimeInMinutes)).setter(CreateDeploymentStrategyRequest.setter(Builder::finalBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build()}).build();
    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("GrowthFactor").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::growthFactor)).setter(CreateDeploymentStrategyRequest.setter(Builder::growthFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()}).build();
    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrowthType").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::growthTypeAsString)).setter(CreateDeploymentStrategyRequest.setter(Builder::growthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()}).build();
    private static final SdkField<String> REPLICATE_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicateTo").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::replicateToAsString)).setter(CreateDeploymentStrategyRequest.setter(Builder::replicateTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicateTo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDeploymentStrategyRequest.getter(CreateDeploymentStrategyRequest::tags)).setter(CreateDeploymentStrategyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, GROWTH_FACTOR_FIELD, GROWTH_TYPE_FIELD, REPLICATE_TO_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeploymentStrategyRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final Integer deploymentDurationInMinutes;
    private final Integer finalBakeTimeInMinutes;
    private final Float growthFactor;
    private final String growthType;
    private final String replicateTo;
    private final Map<String, String> tags;

    private CreateDeploymentStrategyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.growthFactor = builder.growthFactor;
        this.growthType = builder.growthType;
        this.replicateTo = builder.replicateTo;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Integer deploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    public final Integer finalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    public final Float growthFactor() {
        return this.growthFactor;
    }

    public final GrowthType growthType() {
        return GrowthType.fromValue(this.growthType);
    }

    public final String growthTypeAsString() {
        return this.growthType;
    }

    public final ReplicateTo replicateTo() {
        return ReplicateTo.fromValue(this.replicateTo);
    }

    public final String replicateToAsString() {
        return this.replicateTo;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicateToAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentStrategyRequest)) {
            return false;
        }
        CreateDeploymentStrategyRequest other = (CreateDeploymentStrategyRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deploymentDurationInMinutes(), other.deploymentDurationInMinutes()) && Objects.equals(this.finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes()) && Objects.equals(this.growthFactor(), other.growthFactor()) && Objects.equals(this.growthTypeAsString(), other.growthTypeAsString()) && Objects.equals(this.replicateToAsString(), other.replicateToAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentStrategyRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DeploymentDurationInMinutes", (Object)this.deploymentDurationInMinutes()).add("FinalBakeTimeInMinutes", (Object)this.finalBakeTimeInMinutes()).add("GrowthFactor", (Object)this.growthFactor()).add("GrowthType", (Object)this.growthTypeAsString()).add("ReplicateTo", (Object)this.replicateToAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeploymentDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.deploymentDurationInMinutes()));
            }
            case "FinalBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.finalBakeTimeInMinutes()));
            }
            case "GrowthFactor": {
                return Optional.ofNullable(clazz.cast(this.growthFactor()));
            }
            case "GrowthType": {
                return Optional.ofNullable(clazz.cast(this.growthTypeAsString()));
            }
            case "ReplicateTo": {
                return Optional.ofNullable(clazz.cast(this.replicateToAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeploymentDurationInMinutes", DEPLOYMENT_DURATION_IN_MINUTES_FIELD);
        map.put("FinalBakeTimeInMinutes", FINAL_BAKE_TIME_IN_MINUTES_FIELD);
        map.put("GrowthFactor", GROWTH_FACTOR_FIELD);
        map.put("GrowthType", GROWTH_TYPE_FIELD);
        map.put("ReplicateTo", REPLICATE_TO_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentStrategyRequest, T> g) {
        return obj -> g.apply((CreateDeploymentStrategyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Integer deploymentDurationInMinutes;
        private Integer finalBakeTimeInMinutes;
        private Float growthFactor;
        private String growthType;
        private String replicateTo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentStrategyRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            this.finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            this.growthFactor(model.growthFactor);
            this.growthType(model.growthType);
            this.replicateTo(model.replicateTo);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final Float getGrowthFactor() {
            return this.growthFactor;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final String getGrowthType() {
            return this.growthType;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final String getReplicateTo() {
            return this.replicateTo;
        }

        public final void setReplicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
        }

        @Override
        public final Builder replicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
            return this;
        }

        @Override
        public final Builder replicateTo(ReplicateTo replicateTo) {
            this.replicateTo(replicateTo == null ? null : replicateTo.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentStrategyRequest build() {
            return new CreateDeploymentStrategyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentStrategyRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder deploymentDurationInMinutes(Integer var1);

        public Builder finalBakeTimeInMinutes(Integer var1);

        public Builder growthFactor(Float var1);

        public Builder growthType(String var1);

        public Builder growthType(GrowthType var1);

        public Builder replicateTo(String var1);

        public Builder replicateTo(ReplicateTo var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

