/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.services.appfabric.model.AuthType;
import software.amazon.awssdk.services.appfabric.model.Credential;
import software.amazon.awssdk.services.appfabric.model.Tag;
import software.amazon.awssdk.services.appfabric.model.TagListCopier;
import software.amazon.awssdk.services.appfabric.model.Tenant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppAuthorizationRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, CreateAppAuthorizationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::appBundleIdentifier)).setter(CreateAppAuthorizationRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<String> APP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("app").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::app)).setter(CreateAppAuthorizationRequest.setter(Builder::app)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()}).build();
    private static final SdkField<Credential> CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credential").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::credential)).setter(CreateAppAuthorizationRequest.setter(Builder::credential)).constructor(Credential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credential").build()}).build();
    private static final SdkField<Tenant> TENANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tenant").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::tenant)).setter(CreateAppAuthorizationRequest.setter(Builder::tenant)).constructor(Tenant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenant").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::authTypeAsString)).setter(CreateAppAuthorizationRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::clientToken)).setter(CreateAppAuthorizationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateAppAuthorizationRequest.getter(CreateAppAuthorizationRequest::tags)).setter(CreateAppAuthorizationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, APP_FIELD, CREDENTIAL_FIELD, TENANT_FIELD, AUTH_TYPE_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAppAuthorizationRequest.memberNameToFieldInitializer();
    private final String appBundleIdentifier;
    private final String app;
    private final Credential credential;
    private final Tenant tenant;
    private final String authType;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateAppAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.app = builder.app;
        this.credential = builder.credential;
        this.tenant = builder.tenant;
        this.authType = builder.authType;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final String app() {
        return this.app;
    }

    public final Credential credential() {
        return this.credential;
    }

    public final Tenant tenant() {
        return this.tenant;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.app());
        hashCode = 31 * hashCode + Objects.hashCode(this.credential());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenant());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppAuthorizationRequest)) {
            return false;
        }
        CreateAppAuthorizationRequest other = (CreateAppAuthorizationRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(this.app(), other.app()) && Objects.equals(this.credential(), other.credential()) && Objects.equals(this.tenant(), other.tenant()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppAuthorizationRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("App", (Object)this.app()).add("Credential", (Object)this.credential()).add("Tenant", (Object)this.tenant()).add("AuthType", (Object)this.authTypeAsString()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "app": {
                return Optional.ofNullable(clazz.cast(this.app()));
            }
            case "credential": {
                return Optional.ofNullable(clazz.cast(this.credential()));
            }
            case "tenant": {
                return Optional.ofNullable(clazz.cast(this.tenant()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("app", APP_FIELD);
        map.put("credential", CREDENTIAL_FIELD);
        map.put("tenant", TENANT_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppAuthorizationRequest, T> g) {
        return obj -> g.apply((CreateAppAuthorizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private String app;
        private Credential credential;
        private Tenant tenant;
        private String authType;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppAuthorizationRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.app(model.app);
            this.credential(model.credential);
            this.tenant(model.tenant);
            this.authType(model.authType);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getApp() {
            return this.app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final Credential.Builder getCredential() {
            return this.credential != null ? this.credential.toBuilder() : null;
        }

        public final void setCredential(Credential.BuilderImpl credential) {
            this.credential = credential != null ? credential.build() : null;
        }

        @Override
        public final Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public final Tenant.Builder getTenant() {
            return this.tenant != null ? this.tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppAuthorizationRequest build() {
            return new CreateAppAuthorizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppAuthorizationRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder app(String var1);

        public Builder credential(Credential var1);

        default public Builder credential(Consumer<Credential.Builder> credential) {
            return this.credential((Credential)((Credential.Builder)Credential.builder().applyMutation(credential)).build());
        }

        public Builder tenant(Tenant var1);

        default public Builder tenant(Consumer<Tenant.Builder> tenant) {
            return this.tenant((Tenant)((Tenant.Builder)Tenant.builder().applyMutation(tenant)).build());
        }

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

