/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Alarm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Alarm> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(Alarm.getter(Alarm::alarmName)).setter(Alarm.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmARN").getter(Alarm.getter(Alarm::alarmARN)).setter(Alarm.setter(Builder::alarmARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, ALARM_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Alarm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alarmName;
    private final String alarmARN;

    private Alarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmARN = builder.alarmARN;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String alarmARN() {
        return this.alarmARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)obj;
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmARN(), other.alarmARN());
    }

    public final String toString() {
        return ToString.builder((String)"Alarm").add("AlarmName", (Object)this.alarmName()).add("AlarmARN", (Object)this.alarmARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmARN": {
                return Optional.ofNullable(clazz.cast(this.alarmARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AlarmName", ALARM_NAME_FIELD);
        map.put("AlarmARN", ALARM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Alarm, T> g) {
        return obj -> g.apply((Alarm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmARN;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            this.alarmName(model.alarmName);
            this.alarmARN(model.alarmARN);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getAlarmARN() {
            return this.alarmARN;
        }

        public final void setAlarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
        }

        @Override
        public final Builder alarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
            return this;
        }

        public Alarm build() {
            return new Alarm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Alarm> {
        public Builder alarmName(String var1);

        public Builder alarmARN(String var1);
    }
}

