/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingActivitiesRequest
extends ApplicationAutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::serviceNamespaceAsString)).setter(DescribeScalingActivitiesRequest.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::resourceId)).setter(DescribeScalingActivitiesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::scalableDimensionAsString)).setter(DescribeScalingActivitiesRequest.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::maxResults)).setter(DescribeScalingActivitiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::nextToken)).setter(DescribeScalingActivitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Boolean> INCLUDE_NOT_SCALED_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeNotScaledActivities").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::includeNotScaledActivities)).setter(DescribeScalingActivitiesRequest.setter(Builder::includeNotScaledActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNotScaledActivities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, INCLUDE_NOT_SCALED_ACTIVITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScalingActivitiesRequest.memberNameToFieldInitializer();
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean includeNotScaledActivities;

    private DescribeScalingActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeNotScaledActivities = builder.includeNotScaledActivities;
    }

    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public final String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public final String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean includeNotScaledActivities() {
        return this.includeNotScaledActivities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNotScaledActivities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest)((Object)obj);
        return Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.includeNotScaledActivities(), other.includeNotScaledActivities());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingActivitiesRequest").add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("IncludeNotScaledActivities", (Object)this.includeNotScaledActivities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IncludeNotScaledActivities": {
                return Optional.ofNullable(clazz.cast(this.includeNotScaledActivities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ScalableDimension", SCALABLE_DIMENSION_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IncludeNotScaledActivities", INCLUDE_NOT_SCALED_ACTIVITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingActivitiesRequest, T> g) {
        return obj -> g.apply((DescribeScalingActivitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingRequest.BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer maxResults;
        private String nextToken;
        private Boolean includeNotScaledActivities;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesRequest model) {
            super(model);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.includeNotScaledActivities(model.includeNotScaledActivities);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getIncludeNotScaledActivities() {
            return this.includeNotScaledActivities;
        }

        public final void setIncludeNotScaledActivities(Boolean includeNotScaledActivities) {
            this.includeNotScaledActivities = includeNotScaledActivities;
        }

        @Override
        public final Builder includeNotScaledActivities(Boolean includeNotScaledActivities) {
            this.includeNotScaledActivities = includeNotScaledActivities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingActivitiesRequest build() {
            return new DescribeScalingActivitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder includeNotScaledActivities(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

