/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLogPatternRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, UpdateLogPatternRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(UpdateLogPatternRequest.getter(UpdateLogPatternRequest::resourceGroupName)).setter(UpdateLogPatternRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatternSetName").getter(UpdateLogPatternRequest.getter(UpdateLogPatternRequest::patternSetName)).setter(UpdateLogPatternRequest.setter(Builder::patternSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()}).build();
    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatternName").getter(UpdateLogPatternRequest.getter(UpdateLogPatternRequest::patternName)).setter(UpdateLogPatternRequest.setter(Builder::patternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pattern").getter(UpdateLogPatternRequest.getter(UpdateLogPatternRequest::pattern)).setter(UpdateLogPatternRequest.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rank").getter(UpdateLogPatternRequest.getter(UpdateLogPatternRequest::rank)).setter(UpdateLogPatternRequest.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rank").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, PATTERN_SET_NAME_FIELD, PATTERN_NAME_FIELD, PATTERN_FIELD, RANK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLogPatternRequest.memberNameToFieldInitializer();
    private final String resourceGroupName;
    private final String patternSetName;
    private final String patternName;
    private final String pattern;
    private final Integer rank;

    private UpdateLogPatternRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
        this.pattern = builder.pattern;
        this.rank = builder.rank;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String patternSetName() {
        return this.patternSetName;
    }

    public final String patternName() {
        return this.patternName;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final Integer rank() {
        return this.rank;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLogPatternRequest)) {
            return false;
        }
        UpdateLogPatternRequest other = (UpdateLogPatternRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.patternSetName(), other.patternSetName()) && Objects.equals(this.patternName(), other.patternName()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.rank(), other.rank());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLogPatternRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("PatternSetName", (Object)this.patternSetName()).add("PatternName", (Object)this.patternName()).add("Pattern", (Object)this.pattern()).add("Rank", (Object)this.rank()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "PatternSetName": {
                return Optional.ofNullable(clazz.cast(this.patternSetName()));
            }
            case "PatternName": {
                return Optional.ofNullable(clazz.cast(this.patternName()));
            }
            case "Pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "Rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("PatternSetName", PATTERN_SET_NAME_FIELD);
        map.put("PatternName", PATTERN_NAME_FIELD);
        map.put("Pattern", PATTERN_FIELD);
        map.put("Rank", RANK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLogPatternRequest, T> g) {
        return obj -> g.apply((UpdateLogPatternRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String patternSetName;
        private String patternName;
        private String pattern;
        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLogPatternRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.patternSetName(model.patternSetName);
            this.patternName(model.patternName);
            this.pattern(model.pattern);
            this.rank(model.rank);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getPatternSetName() {
            return this.patternSetName;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        @Override
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final String getPatternName() {
            return this.patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getPattern() {
            return this.pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLogPatternRequest build() {
            return new UpdateLogPatternRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLogPatternRequest> {
        public Builder resourceGroupName(String var1);

        public Builder patternSetName(String var1);

        public Builder patternName(String var1);

        public Builder pattern(String var1);

        public Builder rank(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

