/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.LogPattern;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLogPatternResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, CreateLogPatternResponse> {
    private static final SdkField<LogPattern> LOG_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPattern").getter(CreateLogPatternResponse.getter(CreateLogPatternResponse::logPattern)).setter(CreateLogPatternResponse.setter(Builder::logPattern)).constructor(LogPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPattern").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(CreateLogPatternResponse.getter(CreateLogPatternResponse::resourceGroupName)).setter(CreateLogPatternResponse.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_PATTERN_FIELD, RESOURCE_GROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLogPatternResponse.memberNameToFieldInitializer();
    private final LogPattern logPattern;
    private final String resourceGroupName;

    private CreateLogPatternResponse(BuilderImpl builder) {
        super(builder);
        this.logPattern = builder.logPattern;
        this.resourceGroupName = builder.resourceGroupName;
    }

    public final LogPattern logPattern() {
        return this.logPattern;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogPatternResponse)) {
            return false;
        }
        CreateLogPatternResponse other = (CreateLogPatternResponse)((Object)obj);
        return Objects.equals(this.logPattern(), other.logPattern()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLogPatternResponse").add("LogPattern", (Object)this.logPattern()).add("ResourceGroupName", (Object)this.resourceGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogPattern": {
                return Optional.ofNullable(clazz.cast(this.logPattern()));
            }
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LogPattern", LOG_PATTERN_FIELD);
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLogPatternResponse, T> g) {
        return obj -> g.apply((CreateLogPatternResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private LogPattern logPattern;
        private String resourceGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogPatternResponse model) {
            super(model);
            this.logPattern(model.logPattern);
            this.resourceGroupName(model.resourceGroupName);
        }

        public final LogPattern.Builder getLogPattern() {
            return this.logPattern != null ? this.logPattern.toBuilder() : null;
        }

        public final void setLogPattern(LogPattern.BuilderImpl logPattern) {
            this.logPattern = logPattern != null ? logPattern.build() : null;
        }

        @Override
        public final Builder logPattern(LogPattern logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        @Override
        public CreateLogPatternResponse build() {
            return new CreateLogPatternResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLogPatternResponse> {
        public Builder logPattern(LogPattern var1);

        default public Builder logPattern(Consumer<LogPattern.Builder> logPattern) {
            return this.logPattern((LogPattern)((LogPattern.Builder)LogPattern.builder().applyMutation(logPattern)).build());
        }

        public Builder resourceGroupName(String var1);
    }
}

