/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.Tier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComponentConfigurationResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, DescribeComponentConfigurationResponse> {
    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Monitor").getter(DescribeComponentConfigurationResponse.getter(DescribeComponentConfigurationResponse::monitor)).setter(DescribeComponentConfigurationResponse.setter(Builder::monitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(DescribeComponentConfigurationResponse.getter(DescribeComponentConfigurationResponse::tierAsString)).setter(DescribeComponentConfigurationResponse.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> COMPONENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentConfiguration").getter(DescribeComponentConfigurationResponse.getter(DescribeComponentConfigurationResponse::componentConfiguration)).setter(DescribeComponentConfigurationResponse.setter(Builder::componentConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_FIELD, TIER_FIELD, COMPONENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComponentConfigurationResponse.memberNameToFieldInitializer();
    private final Boolean monitor;
    private final String tier;
    private final String componentConfiguration;

    private DescribeComponentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.monitor = builder.monitor;
        this.tier = builder.tier;
        this.componentConfiguration = builder.componentConfiguration;
    }

    public final Boolean monitor() {
        return this.monitor;
    }

    public final Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final String componentConfiguration() {
        return this.componentConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitor());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentConfigurationResponse)) {
            return false;
        }
        DescribeComponentConfigurationResponse other = (DescribeComponentConfigurationResponse)((Object)obj);
        return Objects.equals(this.monitor(), other.monitor()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.componentConfiguration(), other.componentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComponentConfigurationResponse").add("Monitor", (Object)this.monitor()).add("Tier", (Object)this.tierAsString()).add("ComponentConfiguration", (Object)this.componentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Monitor": {
                return Optional.ofNullable(clazz.cast(this.monitor()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "ComponentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.componentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Monitor", MONITOR_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("ComponentConfiguration", COMPONENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeComponentConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private Boolean monitor;
        private String tier;
        private String componentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentConfigurationResponse model) {
            super(model);
            this.monitor(model.monitor);
            this.tier(model.tier);
            this.componentConfiguration(model.componentConfiguration);
        }

        public final Boolean getMonitor() {
            return this.monitor;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getComponentConfiguration() {
            return this.componentConfiguration;
        }

        public final void setComponentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
        }

        @Override
        public final Builder componentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
            return this;
        }

        @Override
        public DescribeComponentConfigurationResponse build() {
            return new DescribeComponentConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComponentConfigurationResponse> {
        public Builder monitor(Boolean var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder componentConfiguration(String var1);
    }
}

