/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.Problem;
import software.amazon.awssdk.services.applicationinsights.model.ProblemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProblemsResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListProblemsResponse> {
    private static final SdkField<List<Problem>> PROBLEM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProblemList").getter(ListProblemsResponse.getter(ListProblemsResponse::problemList)).setter(ListProblemsResponse.setter(Builder::problemList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Problem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProblemsResponse.getter(ListProblemsResponse::nextToken)).setter(ListProblemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(ListProblemsResponse.getter(ListProblemsResponse::resourceGroupName)).setter(ListProblemsResponse.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListProblemsResponse.getter(ListProblemsResponse::accountId)).setter(ListProblemsResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_LIST_FIELD, NEXT_TOKEN_FIELD, RESOURCE_GROUP_NAME_FIELD, ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProblemsResponse.memberNameToFieldInitializer();
    private final List<Problem> problemList;
    private final String nextToken;
    private final String resourceGroupName;
    private final String accountId;

    private ListProblemsResponse(BuilderImpl builder) {
        super(builder);
        this.problemList = builder.problemList;
        this.nextToken = builder.nextToken;
        this.resourceGroupName = builder.resourceGroupName;
        this.accountId = builder.accountId;
    }

    public final boolean hasProblemList() {
        return this.problemList != null && !(this.problemList instanceof SdkAutoConstructList);
    }

    public final List<Problem> problemList() {
        return this.problemList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProblemList() ? this.problemList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProblemsResponse)) {
            return false;
        }
        ListProblemsResponse other = (ListProblemsResponse)((Object)obj);
        return this.hasProblemList() == other.hasProblemList() && Objects.equals(this.problemList(), other.problemList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"ListProblemsResponse").add("ProblemList", this.hasProblemList() ? this.problemList() : null).add("NextToken", (Object)this.nextToken()).add("ResourceGroupName", (Object)this.resourceGroupName()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProblemList": {
                return Optional.ofNullable(clazz.cast(this.problemList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProblemList", PROBLEM_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProblemsResponse, T> g) {
        return obj -> g.apply((ListProblemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private List<Problem> problemList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String resourceGroupName;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProblemsResponse model) {
            super(model);
            this.problemList(model.problemList);
            this.nextToken(model.nextToken);
            this.resourceGroupName(model.resourceGroupName);
            this.accountId(model.accountId);
        }

        public final List<Problem.Builder> getProblemList() {
            List<Problem.Builder> result = ProblemListCopier.copyToBuilder(this.problemList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProblemList(Collection<Problem.BuilderImpl> problemList) {
            this.problemList = ProblemListCopier.copyFromBuilder(problemList);
        }

        @Override
        public final Builder problemList(Collection<Problem> problemList) {
            this.problemList = ProblemListCopier.copy(problemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problemList(Problem ... problemList) {
            this.problemList(Arrays.asList(problemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problemList(Consumer<Problem.Builder> ... problemList) {
            this.problemList(Stream.of(problemList).map(c -> (Problem)((Problem.Builder)Problem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public ListProblemsResponse build() {
            return new ListProblemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProblemsResponse> {
        public Builder problemList(Collection<Problem> var1);

        public Builder problemList(Problem ... var1);

        public Builder problemList(Consumer<Problem.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder resourceGroupName(String var1);

        public Builder accountId(String var1);
    }
}

