/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.ConnectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Edge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Edge> {
    private static final SdkField<String> SOURCE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceNodeId").getter(Edge.getter(Edge::sourceNodeId)).setter(Edge.setter(Builder::sourceNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceNodeId").build()}).build();
    private static final SdkField<String> DESTINATION_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationNodeId").getter(Edge.getter(Edge::destinationNodeId)).setter(Edge.setter(Builder::destinationNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationNodeId").build()}).build();
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Duration").getter(Edge.getter(Edge::duration)).setter(Edge.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(Edge.getter(Edge::connectionTypeAsString)).setter(Edge.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NODE_ID_FIELD, DESTINATION_NODE_ID_FIELD, DURATION_FIELD, CONNECTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Edge.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceNodeId;
    private final String destinationNodeId;
    private final Double duration;
    private final String connectionType;

    private Edge(BuilderImpl builder) {
        this.sourceNodeId = builder.sourceNodeId;
        this.destinationNodeId = builder.destinationNodeId;
        this.duration = builder.duration;
        this.connectionType = builder.connectionType;
    }

    public final String sourceNodeId() {
        return this.sourceNodeId;
    }

    public final String destinationNodeId() {
        return this.destinationNodeId;
    }

    public final Double duration() {
        return this.duration;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.sourceNodeId(), other.sourceNodeId()) && Objects.equals(this.destinationNodeId(), other.destinationNodeId()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Edge").add("SourceNodeId", (Object)this.sourceNodeId()).add("DestinationNodeId", (Object)this.destinationNodeId()).add("Duration", (Object)this.duration()).add("ConnectionType", (Object)this.connectionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceNodeId": {
                return Optional.ofNullable(clazz.cast(this.sourceNodeId()));
            }
            case "DestinationNodeId": {
                return Optional.ofNullable(clazz.cast(this.destinationNodeId()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceNodeId", SOURCE_NODE_ID_FIELD);
        map.put("DestinationNodeId", DESTINATION_NODE_ID_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Edge, T> g) {
        return obj -> g.apply((Edge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceNodeId;
        private String destinationNodeId;
        private Double duration;
        private String connectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            this.sourceNodeId(model.sourceNodeId);
            this.destinationNodeId(model.destinationNodeId);
            this.duration(model.duration);
            this.connectionType(model.connectionType);
        }

        public final String getSourceNodeId() {
            return this.sourceNodeId;
        }

        public final void setSourceNodeId(String sourceNodeId) {
            this.sourceNodeId = sourceNodeId;
        }

        @Override
        public final Builder sourceNodeId(String sourceNodeId) {
            this.sourceNodeId = sourceNodeId;
            return this;
        }

        public final String getDestinationNodeId() {
            return this.destinationNodeId;
        }

        public final void setDestinationNodeId(String destinationNodeId) {
            this.destinationNodeId = destinationNodeId;
        }

        @Override
        public final Builder destinationNodeId(String destinationNodeId) {
            this.destinationNodeId = destinationNodeId;
            return this;
        }

        public final Double getDuration() {
            return this.duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public Edge build() {
            return new Edge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Edge> {
        public Builder sourceNodeId(String var1);

        public Builder destinationNodeId(String var1);

        public Builder duration(Double var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);
    }
}

