/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.CanaryEntity;
import software.amazon.awssdk.services.applicationsignals.model.ServiceEntity;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveEntity;
import software.amazon.awssdk.services.applicationsignals.model.ServiceOperationEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditTargetEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditTargetEntity> {
    private static final SdkField<ServiceEntity> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Service").getter(AuditTargetEntity.getter(AuditTargetEntity::service)).setter(AuditTargetEntity.setter(Builder::service)).constructor(ServiceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<ServiceLevelObjectiveEntity> SLO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Slo").getter(AuditTargetEntity.getter(AuditTargetEntity::slo)).setter(AuditTargetEntity.setter(Builder::slo)).constructor(ServiceLevelObjectiveEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slo").build()}).build();
    private static final SdkField<ServiceOperationEntity> SERVICE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceOperation").getter(AuditTargetEntity.getter(AuditTargetEntity::serviceOperation)).setter(AuditTargetEntity.setter(Builder::serviceOperation)).constructor(ServiceOperationEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceOperation").build()}).build();
    private static final SdkField<CanaryEntity> CANARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Canary").getter(AuditTargetEntity.getter(AuditTargetEntity::canary)).setter(AuditTargetEntity.setter(Builder::canary)).constructor(CanaryEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Canary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, SLO_FIELD, SERVICE_OPERATION_FIELD, CANARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditTargetEntity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ServiceEntity service;
    private final ServiceLevelObjectiveEntity slo;
    private final ServiceOperationEntity serviceOperation;
    private final CanaryEntity canary;
    private final Type type;

    private AuditTargetEntity(BuilderImpl builder) {
        this.service = builder.service;
        this.slo = builder.slo;
        this.serviceOperation = builder.serviceOperation;
        this.canary = builder.canary;
        this.type = builder.type;
    }

    public final ServiceEntity service() {
        return this.service;
    }

    public final ServiceLevelObjectiveEntity slo() {
        return this.slo;
    }

    public final ServiceOperationEntity serviceOperation() {
        return this.serviceOperation;
    }

    public final CanaryEntity canary() {
        return this.canary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.slo());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.canary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditTargetEntity)) {
            return false;
        }
        AuditTargetEntity other = (AuditTargetEntity)obj;
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.slo(), other.slo()) && Objects.equals(this.serviceOperation(), other.serviceOperation()) && Objects.equals(this.canary(), other.canary());
    }

    public final String toString() {
        return ToString.builder((String)"AuditTargetEntity").add("Service", (Object)this.service()).add("Slo", (Object)this.slo()).add("ServiceOperation", (Object)this.serviceOperation()).add("Canary", (Object)this.canary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Slo": {
                return Optional.ofNullable(clazz.cast(this.slo()));
            }
            case "ServiceOperation": {
                return Optional.ofNullable(clazz.cast(this.serviceOperation()));
            }
            case "Canary": {
                return Optional.ofNullable(clazz.cast(this.canary()));
            }
        }
        return Optional.empty();
    }

    public static AuditTargetEntity fromService(ServiceEntity service) {
        return (AuditTargetEntity)AuditTargetEntity.builder().service(service).build();
    }

    public static AuditTargetEntity fromService(Consumer<ServiceEntity.Builder> service) {
        ServiceEntity.Builder builder = ServiceEntity.builder();
        service.accept(builder);
        return AuditTargetEntity.fromService((ServiceEntity)builder.build());
    }

    public static AuditTargetEntity fromSlo(ServiceLevelObjectiveEntity slo) {
        return (AuditTargetEntity)AuditTargetEntity.builder().slo(slo).build();
    }

    public static AuditTargetEntity fromSlo(Consumer<ServiceLevelObjectiveEntity.Builder> slo) {
        ServiceLevelObjectiveEntity.Builder builder = ServiceLevelObjectiveEntity.builder();
        slo.accept(builder);
        return AuditTargetEntity.fromSlo((ServiceLevelObjectiveEntity)builder.build());
    }

    public static AuditTargetEntity fromServiceOperation(ServiceOperationEntity serviceOperation) {
        return (AuditTargetEntity)AuditTargetEntity.builder().serviceOperation(serviceOperation).build();
    }

    public static AuditTargetEntity fromServiceOperation(Consumer<ServiceOperationEntity.Builder> serviceOperation) {
        ServiceOperationEntity.Builder builder = ServiceOperationEntity.builder();
        serviceOperation.accept(builder);
        return AuditTargetEntity.fromServiceOperation((ServiceOperationEntity)builder.build());
    }

    public static AuditTargetEntity fromCanary(CanaryEntity canary) {
        return (AuditTargetEntity)AuditTargetEntity.builder().canary(canary).build();
    }

    public static AuditTargetEntity fromCanary(Consumer<CanaryEntity.Builder> canary) {
        CanaryEntity.Builder builder = CanaryEntity.builder();
        canary.accept(builder);
        return AuditTargetEntity.fromCanary((CanaryEntity)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Service", SERVICE_FIELD);
        map.put("Slo", SLO_FIELD);
        map.put("ServiceOperation", SERVICE_OPERATION_FIELD);
        map.put("Canary", CANARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditTargetEntity, T> g) {
        return obj -> g.apply((AuditTargetEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SERVICE,
        SLO,
        SERVICE_OPERATION,
        CANARY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ServiceEntity service;
        private ServiceLevelObjectiveEntity slo;
        private ServiceOperationEntity serviceOperation;
        private CanaryEntity canary;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuditTargetEntity model) {
            this.service(model.service);
            this.slo(model.slo);
            this.serviceOperation(model.serviceOperation);
            this.canary(model.canary);
        }

        public final ServiceEntity.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        public final void setService(ServiceEntity.BuilderImpl service) {
            ServiceEntity oldValue = this.service;
            this.service = service != null ? service.build() : null;
            this.handleUnionValueChange(Type.SERVICE, oldValue, this.service);
        }

        @Override
        public final Builder service(ServiceEntity service) {
            ServiceEntity oldValue = this.service;
            this.service = service;
            this.handleUnionValueChange(Type.SERVICE, oldValue, this.service);
            return this;
        }

        public final ServiceLevelObjectiveEntity.Builder getSlo() {
            return this.slo != null ? this.slo.toBuilder() : null;
        }

        public final void setSlo(ServiceLevelObjectiveEntity.BuilderImpl slo) {
            ServiceLevelObjectiveEntity oldValue = this.slo;
            this.slo = slo != null ? slo.build() : null;
            this.handleUnionValueChange(Type.SLO, oldValue, this.slo);
        }

        @Override
        public final Builder slo(ServiceLevelObjectiveEntity slo) {
            ServiceLevelObjectiveEntity oldValue = this.slo;
            this.slo = slo;
            this.handleUnionValueChange(Type.SLO, oldValue, this.slo);
            return this;
        }

        public final ServiceOperationEntity.Builder getServiceOperation() {
            return this.serviceOperation != null ? this.serviceOperation.toBuilder() : null;
        }

        public final void setServiceOperation(ServiceOperationEntity.BuilderImpl serviceOperation) {
            ServiceOperationEntity oldValue = this.serviceOperation;
            this.serviceOperation = serviceOperation != null ? serviceOperation.build() : null;
            this.handleUnionValueChange(Type.SERVICE_OPERATION, oldValue, this.serviceOperation);
        }

        @Override
        public final Builder serviceOperation(ServiceOperationEntity serviceOperation) {
            ServiceOperationEntity oldValue = this.serviceOperation;
            this.serviceOperation = serviceOperation;
            this.handleUnionValueChange(Type.SERVICE_OPERATION, oldValue, this.serviceOperation);
            return this;
        }

        public final CanaryEntity.Builder getCanary() {
            return this.canary != null ? this.canary.toBuilder() : null;
        }

        public final void setCanary(CanaryEntity.BuilderImpl canary) {
            CanaryEntity oldValue = this.canary;
            this.canary = canary != null ? canary.build() : null;
            this.handleUnionValueChange(Type.CANARY, oldValue, this.canary);
        }

        @Override
        public final Builder canary(CanaryEntity canary) {
            CanaryEntity oldValue = this.canary;
            this.canary = canary;
            this.handleUnionValueChange(Type.CANARY, oldValue, this.canary);
            return this;
        }

        public AuditTargetEntity build() {
            return new AuditTargetEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditTargetEntity> {
        public Builder service(ServiceEntity var1);

        default public Builder service(Consumer<ServiceEntity.Builder> service) {
            return this.service((ServiceEntity)((ServiceEntity.Builder)ServiceEntity.builder().applyMutation(service)).build());
        }

        public Builder slo(ServiceLevelObjectiveEntity var1);

        default public Builder slo(Consumer<ServiceLevelObjectiveEntity.Builder> slo) {
            return this.slo((ServiceLevelObjectiveEntity)((ServiceLevelObjectiveEntity.Builder)ServiceLevelObjectiveEntity.builder().applyMutation(slo)).build());
        }

        public Builder serviceOperation(ServiceOperationEntity var1);

        default public Builder serviceOperation(Consumer<ServiceOperationEntity.Builder> serviceOperation) {
            return this.serviceOperation((ServiceOperationEntity)((ServiceOperationEntity.Builder)ServiceOperationEntity.builder().applyMutation(serviceOperation)).build());
        }

        public Builder canary(CanaryEntity var1);

        default public Builder canary(Consumer<CanaryEntity.Builder> canary) {
            return this.canary((CanaryEntity)((CanaryEntity.Builder)CanaryEntity.builder().applyMutation(canary)).build());
        }
    }
}

