/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.DurationUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalendarInterval
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CalendarInterval> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CalendarInterval.getter(CalendarInterval::startTime)).setter(CalendarInterval.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> DURATION_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationUnit").getter(CalendarInterval.getter(CalendarInterval::durationUnitAsString)).setter(CalendarInterval.setter(Builder::durationUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationUnit").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(CalendarInterval.getter(CalendarInterval::duration)).setter(CalendarInterval.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, DURATION_UNIT_FIELD, DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalendarInterval.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final String durationUnit;
    private final Integer duration;

    private CalendarInterval(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.durationUnit = builder.durationUnit;
        this.duration = builder.duration;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final DurationUnit durationUnit() {
        return DurationUnit.fromValue(this.durationUnit);
    }

    public final String durationUnitAsString() {
        return this.durationUnit;
    }

    public final Integer duration() {
        return this.duration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarInterval)) {
            return false;
        }
        CalendarInterval other = (CalendarInterval)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.durationUnitAsString(), other.durationUnitAsString()) && Objects.equals(this.duration(), other.duration());
    }

    public final String toString() {
        return ToString.builder((String)"CalendarInterval").add("StartTime", (Object)this.startTime()).add("DurationUnit", (Object)this.durationUnitAsString()).add("Duration", (Object)this.duration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "DurationUnit": {
                return Optional.ofNullable(clazz.cast(this.durationUnitAsString()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("DurationUnit", DURATION_UNIT_FIELD);
        map.put("Duration", DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalendarInterval, T> g) {
        return obj -> g.apply((CalendarInterval)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private String durationUnit;
        private Integer duration;

        private BuilderImpl() {
        }

        private BuilderImpl(CalendarInterval model) {
            this.startTime(model.startTime);
            this.durationUnit(model.durationUnit);
            this.duration(model.duration);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDurationUnit() {
            return this.durationUnit;
        }

        public final void setDurationUnit(String durationUnit) {
            this.durationUnit = durationUnit;
        }

        @Override
        public final Builder durationUnit(String durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        @Override
        public final Builder durationUnit(DurationUnit durationUnit) {
            this.durationUnit(durationUnit == null ? null : durationUnit.toString());
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public CalendarInterval build() {
            return new CalendarInterval(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CalendarInterval> {
        public Builder startTime(Instant var1);

        public Builder durationUnit(String var1);

        public Builder durationUnit(DurationUnit var1);

        public Builder duration(Integer var1);
    }
}

