/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ChangeEvent;
import software.amazon.awssdk.services.applicationsignals.model.ChangeEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntityEventsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListEntityEventsResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListEntityEventsResponse.getter(ListEntityEventsResponse::startTime)).setter(ListEntityEventsResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListEntityEventsResponse.getter(ListEntityEventsResponse::endTime)).setter(ListEntityEventsResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<ChangeEvent>> CHANGE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeEvents").getter(ListEntityEventsResponse.getter(ListEntityEventsResponse::changeEvents)).setter(ListEntityEventsResponse.setter(Builder::changeEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntityEventsResponse.getter(ListEntityEventsResponse::nextToken)).setter(ListEntityEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, CHANGE_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntityEventsResponse.memberNameToFieldInitializer();
    private final Instant startTime;
    private final Instant endTime;
    private final List<ChangeEvent> changeEvents;
    private final String nextToken;

    private ListEntityEventsResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.changeEvents = builder.changeEvents;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasChangeEvents() {
        return this.changeEvents != null && !(this.changeEvents instanceof SdkAutoConstructList);
    }

    public final List<ChangeEvent> changeEvents() {
        return this.changeEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeEvents() ? this.changeEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityEventsResponse)) {
            return false;
        }
        ListEntityEventsResponse other = (ListEntityEventsResponse)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasChangeEvents() == other.hasChangeEvents() && Objects.equals(this.changeEvents(), other.changeEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntityEventsResponse").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ChangeEvents", this.hasChangeEvents() ? this.changeEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ChangeEvents": {
                return Optional.ofNullable(clazz.cast(this.changeEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ChangeEvents", CHANGE_EVENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntityEventsResponse, T> g) {
        return obj -> g.apply((ListEntityEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<ChangeEvent> changeEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityEventsResponse model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.changeEvents(model.changeEvents);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ChangeEvent.Builder> getChangeEvents() {
            List<ChangeEvent.Builder> result = ChangeEventsCopier.copyToBuilder(this.changeEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeEvents(Collection<ChangeEvent.BuilderImpl> changeEvents) {
            this.changeEvents = ChangeEventsCopier.copyFromBuilder(changeEvents);
        }

        @Override
        public final Builder changeEvents(Collection<ChangeEvent> changeEvents) {
            this.changeEvents = ChangeEventsCopier.copy(changeEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeEvents(ChangeEvent ... changeEvents) {
            this.changeEvents(Arrays.asList(changeEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeEvents(Consumer<ChangeEvent.Builder> ... changeEvents) {
            this.changeEvents(Stream.of(changeEvents).map(c -> (ChangeEvent)((ChangeEvent.Builder)ChangeEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntityEventsResponse build() {
            return new ListEntityEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntityEventsResponse> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder changeEvents(Collection<ChangeEvent> var1);

        public Builder changeEvents(ChangeEvent ... var1);

        public Builder changeEvents(Consumer<ChangeEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

