/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricGraph
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricGraph> {
    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDataQueries").getter(MetricGraph.getter(MetricGraph::metricDataQueries)).setter(MetricGraph.setter(Builder::metricDataQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MetricGraph.getter(MetricGraph::startTime)).setter(MetricGraph.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MetricGraph.getter(MetricGraph::endTime)).setter(MetricGraph.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_QUERIES_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricGraph.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MetricDataQuery> metricDataQueries;
    private final Instant startTime;
    private final Instant endTime;

    private MetricGraph(BuilderImpl builder) {
        this.metricDataQueries = builder.metricDataQueries;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final boolean hasMetricDataQueries() {
        return this.metricDataQueries != null && !(this.metricDataQueries instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> metricDataQueries() {
        return this.metricDataQueries;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataQueries() ? this.metricDataQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricGraph)) {
            return false;
        }
        MetricGraph other = (MetricGraph)obj;
        return this.hasMetricDataQueries() == other.hasMetricDataQueries() && Objects.equals(this.metricDataQueries(), other.metricDataQueries()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"MetricGraph").add("MetricDataQueries", this.hasMetricDataQueries() ? this.metricDataQueries() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDataQueries": {
                return Optional.ofNullable(clazz.cast(this.metricDataQueries()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricDataQueries", METRIC_DATA_QUERIES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricGraph, T> g) {
        return obj -> g.apply((MetricGraph)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricGraph model) {
            this.metricDataQueries(model.metricDataQueries);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery ... metricDataQueries) {
            this.metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... metricDataQueries) {
            this.metricDataQueries(Stream.of(metricDataQueries).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public MetricGraph build() {
            return new MetricGraph(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricGraph> {
        public Builder metricDataQueries(Collection<MetricDataQuery> var1);

        public Builder metricDataQueries(MetricDataQuery ... var1);

        public Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

