/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ExclusionWindow;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectiveExclusionWindowsResponse;

public class ListServiceLevelObjectiveExclusionWindowsIterable
implements SdkIterable<ListServiceLevelObjectiveExclusionWindowsResponse> {
    private final ApplicationSignalsClient client;
    private final ListServiceLevelObjectiveExclusionWindowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceLevelObjectiveExclusionWindowsIterable(ApplicationSignalsClient client, ListServiceLevelObjectiveExclusionWindowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceLevelObjectiveExclusionWindowsResponseFetcher();
    }

    public Iterator<ListServiceLevelObjectiveExclusionWindowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExclusionWindow> exclusionWindows() {
        Function<ListServiceLevelObjectiveExclusionWindowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exclusionWindows() != null) {
                return response.exclusionWindows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceLevelObjectiveExclusionWindowsResponseFetcher
    implements SyncPageFetcher<ListServiceLevelObjectiveExclusionWindowsResponse> {
        private ListServiceLevelObjectiveExclusionWindowsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceLevelObjectiveExclusionWindowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceLevelObjectiveExclusionWindowsResponse nextPage(ListServiceLevelObjectiveExclusionWindowsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceLevelObjectiveExclusionWindowsIterable.this.client.listServiceLevelObjectiveExclusionWindows(ListServiceLevelObjectiveExclusionWindowsIterable.this.firstRequest);
            }
            return ListServiceLevelObjectiveExclusionWindowsIterable.this.client.listServiceLevelObjectiveExclusionWindows((ListServiceLevelObjectiveExclusionWindowsRequest)((Object)ListServiceLevelObjectiveExclusionWindowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

