/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.DataMapCopier;
import software.amazon.awssdk.services.applicationsignals.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditorResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditorResult> {
    private static final SdkField<String> AUDITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Auditor").getter(AuditorResult.getter(AuditorResult::auditor)).setter(AuditorResult.setter(Builder::auditor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auditor").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AuditorResult.getter(AuditorResult::description)).setter(AuditorResult.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Data").getter(AuditorResult.getter(AuditorResult::data)).setter(AuditorResult.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(AuditorResult.getter(AuditorResult::severityAsString)).setter(AuditorResult.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDITOR_FIELD, DESCRIPTION_FIELD, DATA_FIELD, SEVERITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditorResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String auditor;
    private final String description;
    private final Map<String, String> data;
    private final String severity;

    private AuditorResult(BuilderImpl builder) {
        this.auditor = builder.auditor;
        this.description = builder.description;
        this.data = builder.data;
        this.severity = builder.severity;
    }

    public final String auditor() {
        return this.auditor;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> data() {
        return this.data;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.auditor());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditorResult)) {
            return false;
        }
        AuditorResult other = (AuditorResult)obj;
        return Objects.equals(this.auditor(), other.auditor()) && Objects.equals(this.description(), other.description()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && Objects.equals(this.severityAsString(), other.severityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AuditorResult").add("Auditor", (Object)this.auditor()).add("Description", (Object)this.description()).add("Data", this.hasData() ? this.data() : null).add("Severity", (Object)this.severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Auditor": {
                return Optional.ofNullable(clazz.cast(this.auditor()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Auditor", AUDITOR_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Data", DATA_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditorResult, T> g) {
        return obj -> g.apply((AuditorResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String auditor;
        private String description;
        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditorResult model) {
            this.auditor(model.auditor);
            this.description(model.description);
            this.data(model.data);
            this.severity(model.severity);
        }

        public final String getAuditor() {
            return this.auditor;
        }

        public final void setAuditor(String auditor) {
            this.auditor = auditor;
        }

        @Override
        public final Builder auditor(String auditor) {
            this.auditor = auditor;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getData() {
            if (this.data instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.data;
        }

        public final void setData(Map<String, String> data) {
            this.data = DataMapCopier.copy(data);
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = DataMapCopier.copy(data);
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public AuditorResult build() {
            return new AuditorResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditorResult> {
        public Builder auditor(String var1);

        public Builder description(String var1);

        public Builder data(Map<String, String> var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);
    }
}

