/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsError;
import software.amazon.awssdk.services.applicationsignals.model.BatchUpdateExclusionWindowsErrorsCopier;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateExclusionWindowsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, BatchUpdateExclusionWindowsResponse> {
    private static final SdkField<List<String>> SLO_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SloIds").getter(BatchUpdateExclusionWindowsResponse.getter(BatchUpdateExclusionWindowsResponse::sloIds)).setter(BatchUpdateExclusionWindowsResponse.setter(Builder::sloIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateExclusionWindowsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchUpdateExclusionWindowsResponse.getter(BatchUpdateExclusionWindowsResponse::errors)).setter(BatchUpdateExclusionWindowsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateExclusionWindowsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_IDS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateExclusionWindowsResponse.memberNameToFieldInitializer();
    private final List<String> sloIds;
    private final List<BatchUpdateExclusionWindowsError> errors;

    private BatchUpdateExclusionWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.sloIds = builder.sloIds;
        this.errors = builder.errors;
    }

    public final boolean hasSloIds() {
        return this.sloIds != null && !(this.sloIds instanceof SdkAutoConstructList);
    }

    public final List<String> sloIds() {
        return this.sloIds;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateExclusionWindowsError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSloIds() ? this.sloIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateExclusionWindowsResponse)) {
            return false;
        }
        BatchUpdateExclusionWindowsResponse other = (BatchUpdateExclusionWindowsResponse)((Object)obj);
        return this.hasSloIds() == other.hasSloIds() && Objects.equals(this.sloIds(), other.sloIds()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateExclusionWindowsResponse").add("SloIds", this.hasSloIds() ? this.sloIds() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SloIds": {
                return Optional.ofNullable(clazz.cast(this.sloIds()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SloIds", SLO_IDS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateExclusionWindowsResponse, T> g) {
        return obj -> g.apply((BatchUpdateExclusionWindowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private List<String> sloIds = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateExclusionWindowsError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateExclusionWindowsResponse model) {
            super(model);
            this.sloIds(model.sloIds);
            this.errors(model.errors);
        }

        public final Collection<String> getSloIds() {
            if (this.sloIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sloIds;
        }

        public final void setSloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
        }

        @Override
        public final Builder sloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloIds(String ... sloIds) {
            this.sloIds(Arrays.asList(sloIds));
            return this;
        }

        public final List<BatchUpdateExclusionWindowsError.Builder> getErrors() {
            List<BatchUpdateExclusionWindowsError.Builder> result = BatchUpdateExclusionWindowsErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchUpdateExclusionWindowsError.BuilderImpl> errors) {
            this.errors = BatchUpdateExclusionWindowsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchUpdateExclusionWindowsError> errors) {
            this.errors = BatchUpdateExclusionWindowsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchUpdateExclusionWindowsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchUpdateExclusionWindowsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchUpdateExclusionWindowsError)((BatchUpdateExclusionWindowsError.Builder)BatchUpdateExclusionWindowsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateExclusionWindowsResponse build() {
            return new BatchUpdateExclusionWindowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateExclusionWindowsResponse> {
        public Builder sloIds(Collection<String> var1);

        public Builder sloIds(String ... var1);

        public Builder errors(Collection<BatchUpdateExclusionWindowsError> var1);

        public Builder errors(BatchUpdateExclusionWindowsError ... var1);

        public Builder errors(Consumer<BatchUpdateExclusionWindowsError.Builder> ... var1);
    }
}

