/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheckConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheckConfiguration> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(HealthCheckConfiguration.getter(HealthCheckConfiguration::protocolAsString)).setter(HealthCheckConfiguration.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(HealthCheckConfiguration.getter(HealthCheckConfiguration::path)).setter(HealthCheckConfiguration.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(HealthCheckConfiguration.getter(HealthCheckConfiguration::interval)).setter(HealthCheckConfiguration.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(HealthCheckConfiguration.getter(HealthCheckConfiguration::timeout)).setter(HealthCheckConfiguration.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthyThreshold").getter(HealthCheckConfiguration.getter(HealthCheckConfiguration::healthyThreshold)).setter(HealthCheckConfiguration.setter(Builder::healthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThreshold").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnhealthyThreshold").getter(HealthCheckConfiguration.getter(HealthCheckConfiguration::unhealthyThreshold)).setter(HealthCheckConfiguration.setter(Builder::unhealthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PATH_FIELD, INTERVAL_FIELD, TIMEOUT_FIELD, HEALTHY_THRESHOLD_FIELD, UNHEALTHY_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HealthCheckConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final String path;
    private final Integer interval;
    private final Integer timeout;
    private final Integer healthyThreshold;
    private final Integer unhealthyThreshold;

    private HealthCheckConfiguration(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.path = builder.path;
        this.interval = builder.interval;
        this.timeout = builder.timeout;
        this.healthyThreshold = builder.healthyThreshold;
        this.unhealthyThreshold = builder.unhealthyThreshold;
    }

    public final HealthCheckProtocol protocol() {
        return HealthCheckProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String path() {
        return this.path;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer healthyThreshold() {
        return this.healthyThreshold;
    }

    public final Integer unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfiguration)) {
            return false;
        }
        HealthCheckConfiguration other = (HealthCheckConfiguration)obj;
        return Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.healthyThreshold(), other.healthyThreshold()) && Objects.equals(this.unhealthyThreshold(), other.unhealthyThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheckConfiguration").add("Protocol", (Object)this.protocolAsString()).add("Path", (Object)this.path()).add("Interval", (Object)this.interval()).add("Timeout", (Object)this.timeout()).add("HealthyThreshold", (Object)this.healthyThreshold()).add("UnhealthyThreshold", (Object)this.unhealthyThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "HealthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthyThreshold()));
            }
            case "UnhealthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("HealthyThreshold", HEALTHY_THRESHOLD_FIELD);
        map.put("UnhealthyThreshold", UNHEALTHY_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfiguration, T> g) {
        return obj -> g.apply((HealthCheckConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private String path;
        private Integer interval;
        private Integer timeout;
        private Integer healthyThreshold;
        private Integer unhealthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfiguration model) {
            this.protocol(model.protocol);
            this.path(model.path);
            this.interval(model.interval);
            this.timeout(model.timeout);
            this.healthyThreshold(model.healthyThreshold);
            this.unhealthyThreshold(model.unhealthyThreshold);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(HealthCheckProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public HealthCheckConfiguration build() {
            return new HealthCheckConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheckConfiguration> {
        public Builder protocol(String var1);

        public Builder protocol(HealthCheckProtocol var1);

        public Builder path(String var1);

        public Builder interval(Integer var1);

        public Builder timeout(Integer var1);

        public Builder healthyThreshold(Integer var1);

        public Builder unhealthyThreshold(Integer var1);
    }
}

