/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse;
import software.amazon.awssdk.services.appsync.model.Type;

public class ListTypesByAssociationIterable
implements SdkIterable<ListTypesByAssociationResponse> {
    private final AppSyncClient client;
    private final ListTypesByAssociationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypesByAssociationIterable(AppSyncClient client, ListTypesByAssociationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTypesByAssociationResponseFetcher();
    }

    public Iterator<ListTypesByAssociationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Type> types() {
        Function<ListTypesByAssociationResponse, Iterator> getIterator = response -> {
            if (response != null && response.types() != null) {
                return response.types().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTypesByAssociationResponseFetcher
    implements SyncPageFetcher<ListTypesByAssociationResponse> {
        private ListTypesByAssociationResponseFetcher() {
        }

        public boolean hasNextPage(ListTypesByAssociationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTypesByAssociationResponse nextPage(ListTypesByAssociationResponse previousPage) {
            if (previousPage == null) {
                return ListTypesByAssociationIterable.this.client.listTypesByAssociation(ListTypesByAssociationIterable.this.firstRequest);
            }
            return ListTypesByAssociationIterable.this.client.listTypesByAssociation((ListTypesByAssociationRequest)((Object)ListTypesByAssociationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

