/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.Type;

public class ListTypesIterable
implements SdkIterable<ListTypesResponse> {
    private final AppSyncClient client;
    private final ListTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypesIterable(AppSyncClient client, ListTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTypesResponseFetcher();
    }

    public Iterator<ListTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Type> types() {
        Function<ListTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.types() != null) {
                return response.types().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTypesResponseFetcher
    implements SyncPageFetcher<ListTypesResponse> {
        private ListTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTypesResponse nextPage(ListTypesResponse previousPage) {
            if (previousPage == null) {
                return ListTypesIterable.this.client.listTypes(ListTypesIterable.this.firstRequest);
            }
            return ListTypesIterable.this.client.listTypes((ListTypesRequest)((Object)ListTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

