/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.GraphqlApi;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;

public class ListGraphqlApisPublisher
implements SdkPublisher<ListGraphqlApisResponse> {
    private final AppSyncAsyncClient client;
    private final ListGraphqlApisRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGraphqlApisPublisher(AppSyncAsyncClient client, ListGraphqlApisRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGraphqlApisPublisher(AppSyncAsyncClient client, ListGraphqlApisRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGraphqlApisResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGraphqlApisResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GraphqlApi> graphqlApis() {
        Function<ListGraphqlApisResponse, Iterator> getIterator = response -> {
            if (response != null && response.graphqlApis() != null) {
                return response.graphqlApis().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGraphqlApisResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGraphqlApisResponseFetcher
    implements AsyncPageFetcher<ListGraphqlApisResponse> {
        private ListGraphqlApisResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphqlApisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGraphqlApisResponse> nextPage(ListGraphqlApisResponse previousPage) {
            if (previousPage == null) {
                return ListGraphqlApisPublisher.this.client.listGraphqlApis(ListGraphqlApisPublisher.this.firstRequest);
            }
            return ListGraphqlApisPublisher.this.client.listGraphqlApis((ListGraphqlApisRequest)((Object)ListGraphqlApisPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

