/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionEventType {
    UNKNOWN("unknown"),
    EXECUTION_PENDING("executionPending"),
    EXECUTION_STARTED("executionStarted"),
    EXECUTION_SUCCEEDED("executionSucceeded"),
    EXECUTION_FAILED("executionFailed"),
    EXECUTION_PAUSING("executionPausing"),
    EXECUTION_PAUSED("executionPaused"),
    EXECUTION_CANCELING("executionCanceling"),
    EXECUTION_CANCELED("executionCanceled"),
    EXECUTION_PENDING_APPROVAL("executionPendingApproval"),
    EXECUTION_BEHAVIOR_CHANGED_TO_UNGRACEFUL("executionBehaviorChangedToUngraceful"),
    EXECUTION_BEHAVIOR_CHANGED_TO_GRACEFUL("executionBehaviorChangedToGraceful"),
    EXECUTION_PENDING_CHILD_PLAN_MANUAL_APPROVAL("executionPendingChildPlanManualApproval"),
    EXECUTION_SUCCESS_MONITORING_APPLICATION_HEALTH("executionSuccessMonitoringApplicationHealth"),
    STEP_STARTED("stepStarted"),
    STEP_UPDATE("stepUpdate"),
    STEP_SUCCEEDED("stepSucceeded"),
    STEP_FAILED("stepFailed"),
    STEP_SKIPPED("stepSkipped"),
    STEP_PAUSED_BY_ERROR("stepPausedByError"),
    STEP_PAUSED_BY_OPERATOR("stepPausedByOperator"),
    STEP_CANCELED("stepCanceled"),
    STEP_PENDING_APPROVAL("stepPendingApproval"),
    STEP_EXECUTION_BEHAVIOR_CHANGED_TO_UNGRACEFUL("stepExecutionBehaviorChangedToUngraceful"),
    STEP_PENDING_APPLICATION_HEALTH_MONITOR("stepPendingApplicationHealthMonitor"),
    PLAN_EVALUATION_WARNING("planEvaluationWarning"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionEventType> VALUE_MAP;
    private final String value;

    private ExecutionEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionEventType> knownValues() {
        EnumSet<ExecutionEventType> knownValues = EnumSet.allOf(ExecutionEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionEventType.class, ExecutionEventType::toString);
    }
}

