/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.FailedReportOutput;
import software.amazon.awssdk.services.arcregionswitch.model.S3ReportOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportOutput> {
    private static final SdkField<S3ReportOutput> S3_REPORT_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3ReportOutput").getter(ReportOutput.getter(ReportOutput::s3ReportOutput)).setter(ReportOutput.setter(Builder::s3ReportOutput)).constructor(S3ReportOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ReportOutput").build()}).build();
    private static final SdkField<FailedReportOutput> FAILED_REPORT_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failedReportOutput").getter(ReportOutput.getter(ReportOutput::failedReportOutput)).setter(ReportOutput.setter(Builder::failedReportOutput)).constructor(FailedReportOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedReportOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_REPORT_OUTPUT_FIELD, FAILED_REPORT_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3ReportOutput s3ReportOutput;
    private final FailedReportOutput failedReportOutput;
    private final Type type;

    private ReportOutput(BuilderImpl builder) {
        this.s3ReportOutput = builder.s3ReportOutput;
        this.failedReportOutput = builder.failedReportOutput;
        this.type = builder.type;
    }

    public final S3ReportOutput s3ReportOutput() {
        return this.s3ReportOutput;
    }

    public final FailedReportOutput failedReportOutput() {
        return this.failedReportOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReportOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedReportOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportOutput)) {
            return false;
        }
        ReportOutput other = (ReportOutput)obj;
        return Objects.equals(this.s3ReportOutput(), other.s3ReportOutput()) && Objects.equals(this.failedReportOutput(), other.failedReportOutput());
    }

    public final String toString() {
        return ToString.builder((String)"ReportOutput").add("S3ReportOutput", (Object)this.s3ReportOutput()).add("FailedReportOutput", (Object)this.failedReportOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3ReportOutput": {
                return Optional.ofNullable(clazz.cast(this.s3ReportOutput()));
            }
            case "failedReportOutput": {
                return Optional.ofNullable(clazz.cast(this.failedReportOutput()));
            }
        }
        return Optional.empty();
    }

    public static ReportOutput fromS3ReportOutput(S3ReportOutput s3ReportOutput) {
        return (ReportOutput)ReportOutput.builder().s3ReportOutput(s3ReportOutput).build();
    }

    public static ReportOutput fromS3ReportOutput(Consumer<S3ReportOutput.Builder> s3ReportOutput) {
        S3ReportOutput.Builder builder = S3ReportOutput.builder();
        s3ReportOutput.accept(builder);
        return ReportOutput.fromS3ReportOutput((S3ReportOutput)builder.build());
    }

    public static ReportOutput fromFailedReportOutput(FailedReportOutput failedReportOutput) {
        return (ReportOutput)ReportOutput.builder().failedReportOutput(failedReportOutput).build();
    }

    public static ReportOutput fromFailedReportOutput(Consumer<FailedReportOutput.Builder> failedReportOutput) {
        FailedReportOutput.Builder builder = FailedReportOutput.builder();
        failedReportOutput.accept(builder);
        return ReportOutput.fromFailedReportOutput((FailedReportOutput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3ReportOutput", S3_REPORT_OUTPUT_FIELD);
        map.put("failedReportOutput", FAILED_REPORT_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportOutput, T> g) {
        return obj -> g.apply((ReportOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_REPORT_OUTPUT,
        FAILED_REPORT_OUTPUT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3ReportOutput s3ReportOutput;
        private FailedReportOutput failedReportOutput;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReportOutput model) {
            this.s3ReportOutput(model.s3ReportOutput);
            this.failedReportOutput(model.failedReportOutput);
        }

        public final S3ReportOutput.Builder getS3ReportOutput() {
            return this.s3ReportOutput != null ? this.s3ReportOutput.toBuilder() : null;
        }

        public final void setS3ReportOutput(S3ReportOutput.BuilderImpl s3ReportOutput) {
            S3ReportOutput oldValue = this.s3ReportOutput;
            this.s3ReportOutput = s3ReportOutput != null ? s3ReportOutput.build() : null;
            this.handleUnionValueChange(Type.S3_REPORT_OUTPUT, oldValue, this.s3ReportOutput);
        }

        @Override
        public final Builder s3ReportOutput(S3ReportOutput s3ReportOutput) {
            S3ReportOutput oldValue = this.s3ReportOutput;
            this.s3ReportOutput = s3ReportOutput;
            this.handleUnionValueChange(Type.S3_REPORT_OUTPUT, oldValue, this.s3ReportOutput);
            return this;
        }

        public final FailedReportOutput.Builder getFailedReportOutput() {
            return this.failedReportOutput != null ? this.failedReportOutput.toBuilder() : null;
        }

        public final void setFailedReportOutput(FailedReportOutput.BuilderImpl failedReportOutput) {
            FailedReportOutput oldValue = this.failedReportOutput;
            this.failedReportOutput = failedReportOutput != null ? failedReportOutput.build() : null;
            this.handleUnionValueChange(Type.FAILED_REPORT_OUTPUT, oldValue, this.failedReportOutput);
        }

        @Override
        public final Builder failedReportOutput(FailedReportOutput failedReportOutput) {
            FailedReportOutput oldValue = this.failedReportOutput;
            this.failedReportOutput = failedReportOutput;
            this.handleUnionValueChange(Type.FAILED_REPORT_OUTPUT, oldValue, this.failedReportOutput);
            return this;
        }

        public ReportOutput build() {
            return new ReportOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportOutput> {
        public Builder s3ReportOutput(S3ReportOutput var1);

        default public Builder s3ReportOutput(Consumer<S3ReportOutput.Builder> s3ReportOutput) {
            return this.s3ReportOutput((S3ReportOutput)((S3ReportOutput.Builder)S3ReportOutput.builder().applyMutation(s3ReportOutput)).build());
        }

        public Builder failedReportOutput(FailedReportOutput var1);

        default public Builder failedReportOutput(Consumer<FailedReportOutput.Builder> failedReportOutput) {
            return this.failedReportOutput((FailedReportOutput)((FailedReportOutput.Builder)FailedReportOutput.builder().applyMutation(failedReportOutput)).build());
        }
    }
}

