/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftAsyncClient;
import software.amazon.awssdk.services.arczonalshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse;
import software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary;

public class ListManagedResourcesPublisher
implements SdkPublisher<ListManagedResourcesResponse> {
    private final ArcZonalShiftAsyncClient client;
    private final ListManagedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedResourcesPublisher(ArcZonalShiftAsyncClient client, ListManagedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedResourcesPublisher(ArcZonalShiftAsyncClient client, ListManagedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedResourceSummary> items() {
        Function<ListManagedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedResourcesResponseFetcher
    implements AsyncPageFetcher<ListManagedResourcesResponse> {
        private ListManagedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedResourcesResponse> nextPage(ListManagedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListManagedResourcesPublisher.this.client.listManagedResources(ListManagedResourcesPublisher.this.firstRequest);
            }
            return ListManagedResourcesPublisher.this.client.listManagedResources((ListManagedResourcesRequest)((Object)ListManagedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

