/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.artifact.ArtifactClient;
import software.amazon.awssdk.services.artifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.artifact.model.ListReportVersionsRequest;
import software.amazon.awssdk.services.artifact.model.ListReportVersionsResponse;
import software.amazon.awssdk.services.artifact.model.ReportSummary;

public class ListReportVersionsIterable
implements SdkIterable<ListReportVersionsResponse> {
    private final ArtifactClient client;
    private final ListReportVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportVersionsIterable(ArtifactClient client, ListReportVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReportVersionsResponseFetcher();
    }

    public Iterator<ListReportVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReportSummary> reports() {
        Function<ListReportVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reports() != null) {
                return response.reports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReportVersionsResponseFetcher
    implements SyncPageFetcher<ListReportVersionsResponse> {
        private ListReportVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportVersionsResponse nextPage(ListReportVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListReportVersionsIterable.this.client.listReportVersions(ListReportVersionsIterable.this.firstRequest);
            }
            return ListReportVersionsIterable.this.client.listReportVersions((ListReportVersionsRequest)((Object)ListReportVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

