/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name of a prepared statement that could not be returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedPreparedStatementName implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedPreparedStatementName.Builder, UnprocessedPreparedStatementName> {
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(UnprocessedPreparedStatementName::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(UnprocessedPreparedStatementName::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(UnprocessedPreparedStatementName::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_NAME_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String statementName;

    private final String errorCode;

    private final String errorMessage;

    private UnprocessedPreparedStatementName(BuilderImpl builder) {
        this.statementName = builder.statementName;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of a prepared statement that could not be returned due to an error.
     * </p>
     * 
     * @return The name of a prepared statement that could not be returned due to an error.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * The error code returned when the request for the prepared statement failed.
     * </p>
     * 
     * @return The error code returned when the request for the prepared statement failed.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message containing the reason why the prepared statement could not be returned. The following error
     * messages are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INVALID_INPUT</code> - The name of the prepared statement that was provided is not valid (for example, the
     * name is too long).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STATEMENT_NOT_FOUND</code> - A prepared statement with the name provided could not be found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAUTHORIZED</code> - The requester does not have permission to access the workgroup that contains the
     * prepared statement.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The error message containing the reason why the prepared statement could not be returned. The following
     *         error messages are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INVALID_INPUT</code> - The name of the prepared statement that was provided is not valid (for
     *         example, the name is too long).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STATEMENT_NOT_FOUND</code> - A prepared statement with the name provided could not be found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAUTHORIZED</code> - The requester does not have permission to access the workgroup that contains
     *         the prepared statement.
     *         </p>
     *         </li>
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedPreparedStatementName)) {
            return false;
        }
        UnprocessedPreparedStatementName other = (UnprocessedPreparedStatementName) obj;
        return Objects.equals(statementName(), other.statementName()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnprocessedPreparedStatementName").add("StatementName", statementName())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedPreparedStatementName, T> g) {
        return obj -> g.apply((UnprocessedPreparedStatementName) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedPreparedStatementName> {
        /**
         * <p>
         * The name of a prepared statement that could not be returned due to an error.
         * </p>
         * 
         * @param statementName
         *        The name of a prepared statement that could not be returned due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * The error code returned when the request for the prepared statement failed.
         * </p>
         * 
         * @param errorCode
         *        The error code returned when the request for the prepared statement failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message containing the reason why the prepared statement could not be returned. The following error
         * messages are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INVALID_INPUT</code> - The name of the prepared statement that was provided is not valid (for example,
         * the name is too long).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STATEMENT_NOT_FOUND</code> - A prepared statement with the name provided could not be found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAUTHORIZED</code> - The requester does not have permission to access the workgroup that contains the
         * prepared statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorMessage
         *        The error message containing the reason why the prepared statement could not be returned. The
         *        following error messages are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INVALID_INPUT</code> - The name of the prepared statement that was provided is not valid (for
         *        example, the name is too long).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STATEMENT_NOT_FOUND</code> - A prepared statement with the name provided could not be found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAUTHORIZED</code> - The requester does not have permission to access the workgroup that
         *        contains the prepared statement.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String statementName;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedPreparedStatementName model) {
            statementName(model.statementName);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public UnprocessedPreparedStatementName build() {
            return new UnprocessedPreparedStatementName(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
