/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryExecutionResponse extends AthenaResponse implements
        ToCopyableBuilder<GetQueryExecutionResponse.Builder, GetQueryExecutionResponse> {
    private static final SdkField<QueryExecution> QUERY_EXECUTION_FIELD = SdkField
            .<QueryExecution> builder(MarshallingType.SDK_POJO).getter(getter(GetQueryExecutionResponse::queryExecution))
            .setter(setter(Builder::queryExecution)).constructor(QueryExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_FIELD));

    private final QueryExecution queryExecution;

    private GetQueryExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.queryExecution = builder.queryExecution;
    }

    /**
     * <p>
     * Information about the query execution.
     * </p>
     * 
     * @return Information about the query execution.
     */
    public QueryExecution queryExecution() {
        return queryExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryExecution());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryExecutionResponse)) {
            return false;
        }
        GetQueryExecutionResponse other = (GetQueryExecutionResponse) obj;
        return Objects.equals(queryExecution(), other.queryExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetQueryExecutionResponse").add("QueryExecution", queryExecution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryExecution":
            return Optional.ofNullable(clazz.cast(queryExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryExecutionResponse, T> g) {
        return obj -> g.apply((GetQueryExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryExecutionResponse> {
        /**
         * <p>
         * Information about the query execution.
         * </p>
         * 
         * @param queryExecution
         *        Information about the query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryExecution(QueryExecution queryExecution);

        /**
         * <p>
         * Information about the query execution.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryExecution.Builder} avoiding the need to
         * create one manually via {@link QueryExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #queryExecution(QueryExecution)}.
         * 
         * @param queryExecution
         *        a consumer that will call methods on {@link QueryExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryExecution(QueryExecution)
         */
        default Builder queryExecution(Consumer<QueryExecution.Builder> queryExecution) {
            return queryExecution(QueryExecution.builder().applyMutation(queryExecution).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private QueryExecution queryExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryExecutionResponse model) {
            super(model);
            queryExecution(model.queryExecution);
        }

        public final QueryExecution.Builder getQueryExecution() {
            return queryExecution != null ? queryExecution.toBuilder() : null;
        }

        @Override
        public final Builder queryExecution(QueryExecution queryExecution) {
            this.queryExecution = queryExecution;
            return this;
        }

        public final void setQueryExecution(QueryExecution.BuilderImpl queryExecution) {
            this.queryExecution = queryExecution != null ? queryExecution.build() : null;
        }

        @Override
        public GetQueryExecutionResponse build() {
            return new GetQueryExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
