/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkGroupResponse extends AthenaResponse implements
        ToCopyableBuilder<GetWorkGroupResponse.Builder, GetWorkGroupResponse> {
    private static final SdkField<WorkGroup> WORK_GROUP_FIELD = SdkField.<WorkGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetWorkGroupResponse::workGroup)).setter(setter(Builder::workGroup)).constructor(WorkGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD));

    private final WorkGroup workGroup;

    private GetWorkGroupResponse(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
    }

    /**
     * <p>
     * Information about the workgroup.
     * </p>
     * 
     * @return Information about the workgroup.
     */
    public WorkGroup workGroup() {
        return workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkGroupResponse)) {
            return false;
        }
        GetWorkGroupResponse other = (GetWorkGroupResponse) obj;
        return Objects.equals(workGroup(), other.workGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWorkGroupResponse").add("WorkGroup", workGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkGroupResponse, T> g) {
        return obj -> g.apply((GetWorkGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkGroupResponse> {
        /**
         * <p>
         * Information about the workgroup.
         * </p>
         * 
         * @param workGroup
         *        Information about the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(WorkGroup workGroup);

        /**
         * <p>
         * Information about the workgroup.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkGroup.Builder} avoiding the need to create
         * one manually via {@link WorkGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #workGroup(WorkGroup)}.
         * 
         * @param workGroup
         *        a consumer that will call methods on {@link WorkGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workGroup(WorkGroup)
         */
        default Builder workGroup(Consumer<WorkGroup.Builder> workGroup) {
            return workGroup(WorkGroup.builder().applyMutation(workGroup).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private WorkGroup workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkGroupResponse model) {
            super(model);
            workGroup(model.workGroup);
        }

        public final WorkGroup.Builder getWorkGroup() {
            return workGroup != null ? workGroup.toBuilder() : null;
        }

        @Override
        public final Builder workGroup(WorkGroup workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final void setWorkGroup(WorkGroup.BuilderImpl workGroup) {
            this.workGroup = workGroup != null ? workGroup.build() : null;
        }

        @Override
        public GetWorkGroupResponse build() {
            return new GetWorkGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
