/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNamedQueriesResponse extends AthenaResponse implements
        ToCopyableBuilder<ListNamedQueriesResponse.Builder, ListNamedQueriesResponse> {
    private static final SdkField<List<String>> NAMED_QUERY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListNamedQueriesResponse::namedQueryIds))
            .setter(setter(Builder::namedQueryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNamedQueriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> namedQueryIds;

    private final String nextToken;

    private ListNamedQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.namedQueryIds = builder.namedQueryIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of unique query IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of unique query IDs.
     */
    public List<String> namedQueryIds() {
        return namedQueryIds;
    }

    /**
     * <p>
     * A token to be used by the next request if this request is truncated.
     * </p>
     * 
     * @return A token to be used by the next request if this request is truncated.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namedQueryIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamedQueriesResponse)) {
            return false;
        }
        ListNamedQueriesResponse other = (ListNamedQueriesResponse) obj;
        return Objects.equals(namedQueryIds(), other.namedQueryIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNamedQueriesResponse").add("NamedQueryIds", namedQueryIds()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQueryIds":
            return Optional.ofNullable(clazz.cast(namedQueryIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamedQueriesResponse, T> g) {
        return obj -> g.apply((ListNamedQueriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNamedQueriesResponse> {
        /**
         * <p>
         * The list of unique query IDs.
         * </p>
         * 
         * @param namedQueryIds
         *        The list of unique query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryIds(Collection<String> namedQueryIds);

        /**
         * <p>
         * The list of unique query IDs.
         * </p>
         * 
         * @param namedQueryIds
         *        The list of unique query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryIds(String... namedQueryIds);

        /**
         * <p>
         * A token to be used by the next request if this request is truncated.
         * </p>
         * 
         * @param nextToken
         *        A token to be used by the next request if this request is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<String> namedQueryIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamedQueriesResponse model) {
            super(model);
            namedQueryIds(model.namedQueryIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getNamedQueryIds() {
            return namedQueryIds;
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String... namedQueryIds) {
            namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNamedQueriesResponse build() {
            return new ListNamedQueriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
