/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of data scanned during the query execution and the amount of time that it took to execute, and the type of
 * statement that was run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryExecutionStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryExecutionStatistics.Builder, QueryExecutionStatistics> {
    private static final SdkField<Long> ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(QueryExecutionStatistics::engineExecutionTimeInMillis))
            .setter(setter(Builder::engineExecutionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineExecutionTimeInMillis")
                    .build()).build();

    private static final SdkField<Long> DATA_SCANNED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(QueryExecutionStatistics::dataScannedInBytes)).setter(setter(Builder::dataScannedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataScannedInBytes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD, DATA_SCANNED_IN_BYTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long engineExecutionTimeInMillis;

    private final Long dataScannedInBytes;

    private QueryExecutionStatistics(BuilderImpl builder) {
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.dataScannedInBytes = builder.dataScannedInBytes;
    }

    /**
     * <p>
     * The number of milliseconds that the query took to execute.
     * </p>
     * 
     * @return The number of milliseconds that the query took to execute.
     */
    public Long engineExecutionTimeInMillis() {
        return engineExecutionTimeInMillis;
    }

    /**
     * <p>
     * The number of bytes in the data that was queried.
     * </p>
     * 
     * @return The number of bytes in the data that was queried.
     */
    public Long dataScannedInBytes() {
        return dataScannedInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(dataScannedInBytes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics) obj;
        return Objects.equals(engineExecutionTimeInMillis(), other.engineExecutionTimeInMillis())
                && Objects.equals(dataScannedInBytes(), other.dataScannedInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryExecutionStatistics").add("EngineExecutionTimeInMillis", engineExecutionTimeInMillis())
                .add("DataScannedInBytes", dataScannedInBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(engineExecutionTimeInMillis()));
        case "DataScannedInBytes":
            return Optional.ofNullable(clazz.cast(dataScannedInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatistics, T> g) {
        return obj -> g.apply((QueryExecutionStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryExecutionStatistics> {
        /**
         * <p>
         * The number of milliseconds that the query took to execute.
         * </p>
         * 
         * @param engineExecutionTimeInMillis
         *        The number of milliseconds that the query took to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis);

        /**
         * <p>
         * The number of bytes in the data that was queried.
         * </p>
         * 
         * @param dataScannedInBytes
         *        The number of bytes in the data that was queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataScannedInBytes(Long dataScannedInBytes);
    }

    static final class BuilderImpl implements Builder {
        private Long engineExecutionTimeInMillis;

        private Long dataScannedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatistics model) {
            engineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            dataScannedInBytes(model.dataScannedInBytes);
        }

        public final Long getEngineExecutionTimeInMillis() {
            return engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        public final Long getDataScannedInBytes() {
            return dataScannedInBytes;
        }

        @Override
        public final Builder dataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
            return this;
        }

        public final void setDataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
        }

        @Override
        public QueryExecutionStatistics build() {
            return new QueryExecutionStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
