/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.ShareRequestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAssessmentFrameworkShareRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, DeleteAssessmentFrameworkShareRequest> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(DeleteAssessmentFrameworkShareRequest.getter(DeleteAssessmentFrameworkShareRequest::requestId)).setter(DeleteAssessmentFrameworkShareRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("requestId").build()}).build();
    private static final SdkField<String> REQUEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestType").getter(DeleteAssessmentFrameworkShareRequest.getter(DeleteAssessmentFrameworkShareRequest::requestTypeAsString)).setter(DeleteAssessmentFrameworkShareRequest.setter(Builder::requestType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("requestType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, REQUEST_TYPE_FIELD));
    private final String requestIdValue;
    private final String requestType;

    private DeleteAssessmentFrameworkShareRequest(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.requestType = builder.requestType;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final ShareRequestType requestType() {
        return ShareRequestType.fromValue(this.requestType);
    }

    public final String requestTypeAsString() {
        return this.requestType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssessmentFrameworkShareRequest)) {
            return false;
        }
        DeleteAssessmentFrameworkShareRequest other = (DeleteAssessmentFrameworkShareRequest)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.requestTypeAsString(), other.requestTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAssessmentFrameworkShareRequest").add("RequestId", (Object)this.requestId()).add("RequestType", (Object)this.requestTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "requestType": {
                return Optional.ofNullable(clazz.cast(this.requestTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssessmentFrameworkShareRequest, T> g) {
        return obj -> g.apply((DeleteAssessmentFrameworkShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String requestType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssessmentFrameworkShareRequest model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.requestType(model.requestType);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        @Transient
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getRequestType() {
            return this.requestType;
        }

        public final void setRequestType(String requestType) {
            this.requestType = requestType;
        }

        @Override
        @Transient
        public final Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        @Override
        @Transient
        public final Builder requestType(ShareRequestType requestType) {
            this.requestType(requestType == null ? null : requestType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAssessmentFrameworkShareRequest build() {
            return new DeleteAssessmentFrameworkShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAssessmentFrameworkShareRequest> {
        public Builder requestId(String var1);

        public Builder requestType(String var1);

        public Builder requestType(ShareRequestType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

