/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeywordInputType {
    SELECT_FROM_LIST("SELECT_FROM_LIST"),
    UPLOAD_FILE("UPLOAD_FILE"),
    INPUT_TEXT("INPUT_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeywordInputType> VALUE_MAP;
    private final String value;

    private KeywordInputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeywordInputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeywordInputType> knownValues() {
        EnumSet<KeywordInputType> knownValues = EnumSet.allOf(KeywordInputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeywordInputType.class, KeywordInputType::toString);
    }
}

