/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.ControlSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssessmentControlSetStatusRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, UpdateAssessmentControlSetStatusRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(UpdateAssessmentControlSetStatusRequest.getter(UpdateAssessmentControlSetStatusRequest::assessmentId)).setter(UpdateAssessmentControlSetStatusRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(UpdateAssessmentControlSetStatusRequest.getter(UpdateAssessmentControlSetStatusRequest::controlSetId)).setter(UpdateAssessmentControlSetStatusRequest.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateAssessmentControlSetStatusRequest.getter(UpdateAssessmentControlSetStatusRequest::statusAsString)).setter(UpdateAssessmentControlSetStatusRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(UpdateAssessmentControlSetStatusRequest.getter(UpdateAssessmentControlSetStatusRequest::comment)).setter(UpdateAssessmentControlSetStatusRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, CONTROL_SET_ID_FIELD, STATUS_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAssessmentControlSetStatusRequest.memberNameToFieldInitializer();
    private final String assessmentId;
    private final String controlSetId;
    private final String status;
    private final String comment;

    private UpdateAssessmentControlSetStatusRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.status = builder.status;
        this.comment = builder.comment;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final ControlSetStatus status() {
        return ControlSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentControlSetStatusRequest)) {
            return false;
        }
        UpdateAssessmentControlSetStatusRequest other = (UpdateAssessmentControlSetStatusRequest)((Object)obj);
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssessmentControlSetStatusRequest").add("AssessmentId", (Object)this.assessmentId()).add("ControlSetId", (Object)this.controlSetId()).add("Status", (Object)this.statusAsString()).add("Comment", (Object)(this.comment() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("assessmentId", ASSESSMENT_ID_FIELD);
        map.put("controlSetId", CONTROL_SET_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentControlSetStatusRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentControlSetStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String assessmentId;
        private String controlSetId;
        private String status;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentControlSetStatusRequest model) {
            super(model);
            this.assessmentId(model.assessmentId);
            this.controlSetId(model.controlSetId);
            this.status(model.status);
            this.comment(model.comment);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentControlSetStatusRequest build() {
            return new UpdateAssessmentControlSetStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssessmentControlSetStatusRequest> {
        public Builder assessmentId(String var1);

        public Builder controlSetId(String var1);

        public Builder status(String var1);

        public Builder status(ControlSetStatus var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

