/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse;

public class ListControlDomainInsightsIterable
implements SdkIterable<ListControlDomainInsightsResponse> {
    private final AuditManagerClient client;
    private final ListControlDomainInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlDomainInsightsIterable(AuditManagerClient client, ListControlDomainInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListControlDomainInsightsResponseFetcher();
    }

    public Iterator<ListControlDomainInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListControlDomainInsightsResponseFetcher
    implements SyncPageFetcher<ListControlDomainInsightsResponse> {
        private ListControlDomainInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlDomainInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlDomainInsightsResponse nextPage(ListControlDomainInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListControlDomainInsightsIterable.this.client.listControlDomainInsights(ListControlDomainInsightsIterable.this.firstRequest);
            }
            return ListControlDomainInsightsIterable.this.client.listControlDomainInsights((ListControlDomainInsightsRequest)((Object)ListControlDomainInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

