/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSet;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssessmentFrameworkRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, UpdateAssessmentFrameworkRequest> {
    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameworkId").getter(UpdateAssessmentFrameworkRequest.getter(UpdateAssessmentFrameworkRequest::frameworkId)).setter(UpdateAssessmentFrameworkRequest.setter(Builder::frameworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("frameworkId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAssessmentFrameworkRequest.getter(UpdateAssessmentFrameworkRequest::name)).setter(UpdateAssessmentFrameworkRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAssessmentFrameworkRequest.getter(UpdateAssessmentFrameworkRequest::description)).setter(UpdateAssessmentFrameworkRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(UpdateAssessmentFrameworkRequest.getter(UpdateAssessmentFrameworkRequest::complianceType)).setter(UpdateAssessmentFrameworkRequest.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final SdkField<List<UpdateAssessmentFrameworkControlSet>> CONTROL_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlSets").getter(UpdateAssessmentFrameworkRequest.getter(UpdateAssessmentFrameworkRequest::controlSets)).setter(UpdateAssessmentFrameworkRequest.setter(Builder::controlSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateAssessmentFrameworkControlSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, COMPLIANCE_TYPE_FIELD, CONTROL_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAssessmentFrameworkRequest.memberNameToFieldInitializer();
    private final String frameworkId;
    private final String name;
    private final String description;
    private final String complianceType;
    private final List<UpdateAssessmentFrameworkControlSet> controlSets;

    private UpdateAssessmentFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkId = builder.frameworkId;
        this.name = builder.name;
        this.description = builder.description;
        this.complianceType = builder.complianceType;
        this.controlSets = builder.controlSets;
    }

    public final String frameworkId() {
        return this.frameworkId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final boolean hasControlSets() {
        return this.controlSets != null && !(this.controlSets instanceof SdkAutoConstructList);
    }

    public final List<UpdateAssessmentFrameworkControlSet> controlSets() {
        return this.controlSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlSets() ? this.controlSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentFrameworkRequest)) {
            return false;
        }
        UpdateAssessmentFrameworkRequest other = (UpdateAssessmentFrameworkRequest)((Object)obj);
        return Objects.equals(this.frameworkId(), other.frameworkId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.complianceType(), other.complianceType()) && this.hasControlSets() == other.hasControlSets() && Objects.equals(this.controlSets(), other.controlSets());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssessmentFrameworkRequest").add("FrameworkId", (Object)this.frameworkId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ComplianceType", (Object)(this.complianceType() == null ? null : "*** Sensitive Data Redacted ***")).add("ControlSets", this.hasControlSets() ? this.controlSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameworkId": {
                return Optional.ofNullable(clazz.cast(this.frameworkId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "controlSets": {
                return Optional.ofNullable(clazz.cast(this.controlSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frameworkId", FRAMEWORK_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("complianceType", COMPLIANCE_TYPE_FIELD);
        map.put("controlSets", CONTROL_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentFrameworkRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentFrameworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String frameworkId;
        private String name;
        private String description;
        private String complianceType;
        private List<UpdateAssessmentFrameworkControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentFrameworkRequest model) {
            super(model);
            this.frameworkId(model.frameworkId);
            this.name(model.name);
            this.description(model.description);
            this.complianceType(model.complianceType);
            this.controlSets(model.controlSets);
        }

        public final String getFrameworkId() {
            return this.frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final List<UpdateAssessmentFrameworkControlSet.Builder> getControlSets() {
            List<UpdateAssessmentFrameworkControlSet.Builder> result = UpdateAssessmentFrameworkControlSetsCopier.copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlSets(Collection<UpdateAssessmentFrameworkControlSet.BuilderImpl> controlSets) {
            this.controlSets = UpdateAssessmentFrameworkControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        public final Builder controlSets(Collection<UpdateAssessmentFrameworkControlSet> controlSets) {
            this.controlSets = UpdateAssessmentFrameworkControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(UpdateAssessmentFrameworkControlSet ... controlSets) {
            this.controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(Consumer<UpdateAssessmentFrameworkControlSet.Builder> ... controlSets) {
            this.controlSets(Stream.of(controlSets).map(c -> (UpdateAssessmentFrameworkControlSet)((UpdateAssessmentFrameworkControlSet.Builder)UpdateAssessmentFrameworkControlSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentFrameworkRequest build() {
            return new UpdateAssessmentFrameworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssessmentFrameworkRequest> {
        public Builder frameworkId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder complianceType(String var1);

        public Builder controlSets(Collection<UpdateAssessmentFrameworkControlSet> var1);

        public Builder controlSets(UpdateAssessmentFrameworkControlSet ... var1);

        public Builder controlSets(Consumer<UpdateAssessmentFrameworkControlSet.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

