/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.FileFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestMappingRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, TestMappingRequest> {
    private static final SdkField<String> INPUT_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputFileContent").getter(TestMappingRequest.getter(TestMappingRequest::inputFileContent)).setter(TestMappingRequest.setter(Builder::inputFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileContent").build()}).build();
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingTemplate").getter(TestMappingRequest.getter(TestMappingRequest::mappingTemplate)).setter(TestMappingRequest.setter(Builder::mappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(TestMappingRequest.getter(TestMappingRequest::fileFormatAsString)).setter(TestMappingRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_CONTENT_FIELD, MAPPING_TEMPLATE_FIELD, FILE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestMappingRequest.memberNameToFieldInitializer();
    private final String inputFileContent;
    private final String mappingTemplate;
    private final String fileFormat;

    private TestMappingRequest(BuilderImpl builder) {
        super(builder);
        this.inputFileContent = builder.inputFileContent;
        this.mappingTemplate = builder.mappingTemplate;
        this.fileFormat = builder.fileFormat;
    }

    public final String inputFileContent() {
        return this.inputFileContent;
    }

    public final String mappingTemplate() {
        return this.mappingTemplate;
    }

    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMappingRequest)) {
            return false;
        }
        TestMappingRequest other = (TestMappingRequest)((Object)obj);
        return Objects.equals(this.inputFileContent(), other.inputFileContent()) && Objects.equals(this.mappingTemplate(), other.mappingTemplate()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TestMappingRequest").add("InputFileContent", (Object)this.inputFileContent()).add("MappingTemplate", (Object)this.mappingTemplate()).add("FileFormat", (Object)this.fileFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputFileContent": {
                return Optional.ofNullable(clazz.cast(this.inputFileContent()));
            }
            case "mappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.mappingTemplate()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("inputFileContent", INPUT_FILE_CONTENT_FIELD);
        map.put("mappingTemplate", MAPPING_TEMPLATE_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestMappingRequest, T> g) {
        return obj -> g.apply((TestMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String inputFileContent;
        private String mappingTemplate;
        private String fileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TestMappingRequest model) {
            super(model);
            this.inputFileContent(model.inputFileContent);
            this.mappingTemplate(model.mappingTemplate);
            this.fileFormat(model.fileFormat);
        }

        public final String getInputFileContent() {
            return this.inputFileContent;
        }

        public final void setInputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
        }

        @Override
        public final Builder inputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
            return this;
        }

        public final String getMappingTemplate() {
            return this.mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestMappingRequest build() {
            return new TestMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestMappingRequest> {
        public Builder inputFileContent(String var1);

        public Builder mappingTemplate(String var1);

        public Builder fileFormat(String var1);

        public Builder fileFormat(FileFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

