/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.b2bi.model.EdiConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapabilityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapabilityConfiguration> {
    private static final SdkField<EdiConfiguration> EDI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("edi").getter(CapabilityConfiguration.getter(CapabilityConfiguration::edi)).setter(CapabilityConfiguration.setter(Builder::edi)).constructor(EdiConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edi").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapabilityConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EdiConfiguration edi;
    private final Type type;

    private CapabilityConfiguration(BuilderImpl builder) {
        this.edi = builder.edi;
        this.type = builder.type;
    }

    public final EdiConfiguration edi() {
        return this.edi;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.edi());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityConfiguration)) {
            return false;
        }
        CapabilityConfiguration other = (CapabilityConfiguration)obj;
        return Objects.equals(this.edi(), other.edi());
    }

    public final String toString() {
        return ToString.builder((String)"CapabilityConfiguration").add("Edi", (Object)this.edi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "edi": {
                return Optional.ofNullable(clazz.cast(this.edi()));
            }
        }
        return Optional.empty();
    }

    public static CapabilityConfiguration fromEdi(EdiConfiguration edi) {
        return (CapabilityConfiguration)CapabilityConfiguration.builder().edi(edi).build();
    }

    public static CapabilityConfiguration fromEdi(Consumer<EdiConfiguration.Builder> edi) {
        EdiConfiguration.Builder builder = EdiConfiguration.builder();
        edi.accept(builder);
        return CapabilityConfiguration.fromEdi((EdiConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<EdiConfiguration>> map = new HashMap<String, SdkField<EdiConfiguration>>();
        map.put("edi", EDI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityConfiguration, T> g) {
        return obj -> g.apply((CapabilityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EDI,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EdiConfiguration edi;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityConfiguration model) {
            this.edi(model.edi);
        }

        public final EdiConfiguration.Builder getEdi() {
            return this.edi != null ? this.edi.toBuilder() : null;
        }

        public final void setEdi(EdiConfiguration.BuilderImpl edi) {
            EdiConfiguration oldValue = this.edi;
            this.edi = edi != null ? edi.build() : null;
            this.handleUnionValueChange(Type.EDI, oldValue, this.edi);
        }

        @Override
        public final Builder edi(EdiConfiguration edi) {
            EdiConfiguration oldValue = this.edi;
            this.edi = edi;
            this.handleUnionValueChange(Type.EDI, oldValue, this.edi);
            return this;
        }

        public CapabilityConfiguration build() {
            return new CapabilityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapabilityConfiguration> {
        public Builder edi(EdiConfiguration var1);

        default public Builder edi(Consumer<EdiConfiguration.Builder> edi) {
            return this.edi((EdiConfiguration)((EdiConfiguration.Builder)EdiConfiguration.builder().applyMutation(edi)).build());
        }
    }
}

