/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.b2bi.B2BiClient;
import software.amazon.awssdk.services.b2bi.internal.UserAgentUtils;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse;
import software.amazon.awssdk.services.b2bi.model.PartnershipSummary;

public class ListPartnershipsIterable
implements SdkIterable<ListPartnershipsResponse> {
    private final B2BiClient client;
    private final ListPartnershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPartnershipsIterable(B2BiClient client, ListPartnershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPartnershipsResponseFetcher();
    }

    public Iterator<ListPartnershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PartnershipSummary> partnerships() {
        Function<ListPartnershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.partnerships() != null) {
                return response.partnerships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPartnershipsResponseFetcher
    implements SyncPageFetcher<ListPartnershipsResponse> {
        private ListPartnershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartnershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPartnershipsResponse nextPage(ListPartnershipsResponse previousPage) {
            if (previousPage == null) {
                return ListPartnershipsIterable.this.client.listPartnerships(ListPartnershipsIterable.this.firstRequest);
            }
            return ListPartnershipsIterable.this.client.listPartnerships((ListPartnershipsRequest)((Object)ListPartnershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

