/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.b2bi.model.X12Details;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormatOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormatOptions> {
    private static final SdkField<X12Details> X12_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("x12").getter(FormatOptions.getter(FormatOptions::x12)).setter(FormatOptions.setter(Builder::x12)).constructor(X12Details::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x12").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X12_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FormatOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final X12Details x12;
    private final Type type;

    private FormatOptions(BuilderImpl builder) {
        this.x12 = builder.x12;
        this.type = builder.type;
    }

    public final X12Details x12() {
        return this.x12;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.x12());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormatOptions)) {
            return false;
        }
        FormatOptions other = (FormatOptions)obj;
        return Objects.equals(this.x12(), other.x12());
    }

    public final String toString() {
        return ToString.builder((String)"FormatOptions").add("X12", (Object)this.x12()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "x12": {
                return Optional.ofNullable(clazz.cast(this.x12()));
            }
        }
        return Optional.empty();
    }

    public static FormatOptions fromX12(X12Details x12) {
        return (FormatOptions)FormatOptions.builder().x12(x12).build();
    }

    public static FormatOptions fromX12(Consumer<X12Details.Builder> x12) {
        X12Details.Builder builder = X12Details.builder();
        x12.accept(builder);
        return FormatOptions.fromX12((X12Details)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<X12Details>> map = new HashMap<String, SdkField<X12Details>>();
        map.put("x12", X12_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormatOptions, T> g) {
        return obj -> g.apply((FormatOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        X12,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private X12Details x12;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FormatOptions model) {
            this.x12(model.x12);
        }

        public final X12Details.Builder getX12() {
            return this.x12 != null ? this.x12.toBuilder() : null;
        }

        public final void setX12(X12Details.BuilderImpl x12) {
            X12Details oldValue = this.x12;
            this.x12 = x12 != null ? x12.build() : null;
            this.handleUnionValueChange(Type.X12, oldValue, this.x12);
        }

        @Override
        public final Builder x12(X12Details x12) {
            X12Details oldValue = this.x12;
            this.x12 = x12;
            this.handleUnionValueChange(Type.X12, oldValue, this.x12);
            return this;
        }

        public FormatOptions build() {
            return new FormatOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormatOptions> {
        public Builder x12(X12Details var1);

        default public Builder x12(Consumer<X12Details.Builder> x12) {
            return this.x12((X12Details)((X12Details.Builder)X12Details.builder().applyMutation(x12)).build());
        }
    }
}

