/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputFileSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputFileSource> {
    private static final SdkField<String> FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileContent").getter(InputFileSource.getter(InputFileSource::fileContent)).setter(InputFileSource.setter(Builder::fileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputFileSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileContent;
    private final Type type;

    private InputFileSource(BuilderImpl builder) {
        this.fileContent = builder.fileContent;
        this.type = builder.type;
    }

    public final String fileContent() {
        return this.fileContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFileSource)) {
            return false;
        }
        InputFileSource other = (InputFileSource)obj;
        return Objects.equals(this.fileContent(), other.fileContent());
    }

    public final String toString() {
        return ToString.builder((String)"InputFileSource").add("FileContent", (Object)this.fileContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileContent": {
                return Optional.ofNullable(clazz.cast(this.fileContent()));
            }
        }
        return Optional.empty();
    }

    public static InputFileSource fromFileContent(String fileContent) {
        return (InputFileSource)InputFileSource.builder().fileContent(fileContent).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("fileContent", FILE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputFileSource, T> g) {
        return obj -> g.apply((InputFileSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE_CONTENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String fileContent;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InputFileSource model) {
            this.fileContent(model.fileContent);
        }

        public final String getFileContent() {
            return this.fileContent;
        }

        public final void setFileContent(String fileContent) {
            String oldValue = this.fileContent;
            this.fileContent = fileContent;
            this.handleUnionValueChange(Type.FILE_CONTENT, oldValue, this.fileContent);
        }

        @Override
        public final Builder fileContent(String fileContent) {
            String oldValue = this.fileContent;
            this.fileContent = fileContent;
            this.handleUnionValueChange(Type.FILE_CONTENT, oldValue, this.fileContent);
            return this;
        }

        public InputFileSource build() {
            return new InputFileSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputFileSource> {
        public Builder fileContent(String var1);
    }
}

