/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.b2bi.B2BiAsyncClient;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.waiters.DefaultB2BiAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface B2BiAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetTransformerJobResponse>> waitUntilTransformerJobSucceeded(GetTransformerJobRequest getTransformerJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetTransformerJobResponse>> waitUntilTransformerJobSucceeded(Consumer<GetTransformerJobRequest.Builder> getTransformerJobRequest) {
        return this.waitUntilTransformerJobSucceeded((GetTransformerJobRequest)((Object)((GetTransformerJobRequest.Builder)GetTransformerJobRequest.builder().applyMutation(getTransformerJobRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetTransformerJobResponse>> waitUntilTransformerJobSucceeded(GetTransformerJobRequest getTransformerJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetTransformerJobResponse>> waitUntilTransformerJobSucceeded(Consumer<GetTransformerJobRequest.Builder> getTransformerJobRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTransformerJobSucceeded((GetTransformerJobRequest)((Object)((GetTransformerJobRequest.Builder)GetTransformerJobRequest.builder().applyMutation(getTransformerJobRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultB2BiAsyncWaiter.builder();
    }

    public static B2BiAsyncWaiter create() {
        return DefaultB2BiAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(B2BiAsyncClient var1);

        public B2BiAsyncWaiter build();
    }
}

