/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.CodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12CodeListValidationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12CodeListValidationRule> {
    private static final SdkField<String> ELEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("elementId").getter(X12CodeListValidationRule.getter(X12CodeListValidationRule::elementId)).setter(X12CodeListValidationRule.setter(Builder::elementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementId").build()}).build();
    private static final SdkField<List<String>> CODES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codesToAdd").getter(X12CodeListValidationRule.getter(X12CodeListValidationRule::codesToAdd)).setter(X12CodeListValidationRule.setter(Builder::codesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CODES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codesToRemove").getter(X12CodeListValidationRule.getter(X12CodeListValidationRule::codesToRemove)).setter(X12CodeListValidationRule.setter(Builder::codesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_ID_FIELD, CODES_TO_ADD_FIELD, CODES_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12CodeListValidationRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String elementId;
    private final List<String> codesToAdd;
    private final List<String> codesToRemove;

    private X12CodeListValidationRule(BuilderImpl builder) {
        this.elementId = builder.elementId;
        this.codesToAdd = builder.codesToAdd;
        this.codesToRemove = builder.codesToRemove;
    }

    public final String elementId() {
        return this.elementId;
    }

    public final boolean hasCodesToAdd() {
        return this.codesToAdd != null && !(this.codesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> codesToAdd() {
        return this.codesToAdd;
    }

    public final boolean hasCodesToRemove() {
        return this.codesToRemove != null && !(this.codesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> codesToRemove() {
        return this.codesToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodesToAdd() ? this.codesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodesToRemove() ? this.codesToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12CodeListValidationRule)) {
            return false;
        }
        X12CodeListValidationRule other = (X12CodeListValidationRule)obj;
        return Objects.equals(this.elementId(), other.elementId()) && this.hasCodesToAdd() == other.hasCodesToAdd() && Objects.equals(this.codesToAdd(), other.codesToAdd()) && this.hasCodesToRemove() == other.hasCodesToRemove() && Objects.equals(this.codesToRemove(), other.codesToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"X12CodeListValidationRule").add("ElementId", (Object)this.elementId()).add("CodesToAdd", this.hasCodesToAdd() ? this.codesToAdd() : null).add("CodesToRemove", this.hasCodesToRemove() ? this.codesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elementId": {
                return Optional.ofNullable(clazz.cast(this.elementId()));
            }
            case "codesToAdd": {
                return Optional.ofNullable(clazz.cast(this.codesToAdd()));
            }
            case "codesToRemove": {
                return Optional.ofNullable(clazz.cast(this.codesToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("elementId", ELEMENT_ID_FIELD);
        map.put("codesToAdd", CODES_TO_ADD_FIELD);
        map.put("codesToRemove", CODES_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12CodeListValidationRule, T> g) {
        return obj -> g.apply((X12CodeListValidationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementId;
        private List<String> codesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> codesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(X12CodeListValidationRule model) {
            this.elementId(model.elementId);
            this.codesToAdd(model.codesToAdd);
            this.codesToRemove(model.codesToRemove);
        }

        public final String getElementId() {
            return this.elementId;
        }

        public final void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Collection<String> getCodesToAdd() {
            if (this.codesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.codesToAdd;
        }

        public final void setCodesToAdd(Collection<String> codesToAdd) {
            this.codesToAdd = CodeListCopier.copy(codesToAdd);
        }

        @Override
        public final Builder codesToAdd(Collection<String> codesToAdd) {
            this.codesToAdd = CodeListCopier.copy(codesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codesToAdd(String ... codesToAdd) {
            this.codesToAdd(Arrays.asList(codesToAdd));
            return this;
        }

        public final Collection<String> getCodesToRemove() {
            if (this.codesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.codesToRemove;
        }

        public final void setCodesToRemove(Collection<String> codesToRemove) {
            this.codesToRemove = CodeListCopier.copy(codesToRemove);
        }

        @Override
        public final Builder codesToRemove(Collection<String> codesToRemove) {
            this.codesToRemove = CodeListCopier.copy(codesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codesToRemove(String ... codesToRemove) {
            this.codesToRemove(Arrays.asList(codesToRemove));
            return this;
        }

        public X12CodeListValidationRule build() {
            return new X12CodeListValidationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12CodeListValidationRule> {
        public Builder elementId(String var1);

        public Builder codesToAdd(Collection<String> var1);

        public Builder codesToAdd(String ... var1);

        public Builder codesToRemove(Collection<String> var1);

        public Builder codesToRemove(String ... var1);
    }
}

