/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.EdiType;
import software.amazon.awssdk.services.b2bi.model.FileFormat;
import software.amazon.awssdk.services.b2bi.model.InputConversion;
import software.amazon.awssdk.services.b2bi.model.Mapping;
import software.amazon.awssdk.services.b2bi.model.OutputConversion;
import software.amazon.awssdk.services.b2bi.model.SampleDocuments;
import software.amazon.awssdk.services.b2bi.model.TransformerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransformerResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, CreateTransformerResponse> {
    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformerId").getter(CreateTransformerResponse.getter(CreateTransformerResponse::transformerId)).setter(CreateTransformerResponse.setter(Builder::transformerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()}).build();
    private static final SdkField<String> TRANSFORMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformerArn").getter(CreateTransformerResponse.getter(CreateTransformerResponse::transformerArn)).setter(CreateTransformerResponse.setter(Builder::transformerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTransformerResponse.getter(CreateTransformerResponse::name)).setter(CreateTransformerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateTransformerResponse.getter(CreateTransformerResponse::statusAsString)).setter(CreateTransformerResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateTransformerResponse.getter(CreateTransformerResponse::createdAt)).setter(CreateTransformerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(CreateTransformerResponse.getter(CreateTransformerResponse::fileFormatAsString)).setter(CreateTransformerResponse.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingTemplate").getter(CreateTransformerResponse.getter(CreateTransformerResponse::mappingTemplate)).setter(CreateTransformerResponse.setter(Builder::mappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()}).build();
    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ediType").getter(CreateTransformerResponse.getter(CreateTransformerResponse::ediType)).setter(CreateTransformerResponse.setter(Builder::ediType)).constructor(EdiType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()}).build();
    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleDocument").getter(CreateTransformerResponse.getter(CreateTransformerResponse::sampleDocument)).setter(CreateTransformerResponse.setter(Builder::sampleDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()}).build();
    private static final SdkField<InputConversion> INPUT_CONVERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConversion").getter(CreateTransformerResponse.getter(CreateTransformerResponse::inputConversion)).setter(CreateTransformerResponse.setter(Builder::inputConversion)).constructor(InputConversion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConversion").build()}).build();
    private static final SdkField<Mapping> MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mapping").getter(CreateTransformerResponse.getter(CreateTransformerResponse::mapping)).setter(CreateTransformerResponse.setter(Builder::mapping)).constructor(Mapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapping").build()}).build();
    private static final SdkField<OutputConversion> OUTPUT_CONVERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConversion").getter(CreateTransformerResponse.getter(CreateTransformerResponse::outputConversion)).setter(CreateTransformerResponse.setter(Builder::outputConversion)).constructor(OutputConversion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConversion").build()}).build();
    private static final SdkField<SampleDocuments> SAMPLE_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sampleDocuments").getter(CreateTransformerResponse.getter(CreateTransformerResponse::sampleDocuments)).setter(CreateTransformerResponse.setter(Builder::sampleDocuments)).constructor(SampleDocuments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocuments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_ID_FIELD, TRANSFORMER_ARN_FIELD, NAME_FIELD, STATUS_FIELD, CREATED_AT_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD, INPUT_CONVERSION_FIELD, MAPPING_FIELD, OUTPUT_CONVERSION_FIELD, SAMPLE_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTransformerResponse.memberNameToFieldInitializer();
    private final String transformerId;
    private final String transformerArn;
    private final String name;
    private final String status;
    private final Instant createdAt;
    private final String fileFormat;
    private final String mappingTemplate;
    private final EdiType ediType;
    private final String sampleDocument;
    private final InputConversion inputConversion;
    private final Mapping mapping;
    private final OutputConversion outputConversion;
    private final SampleDocuments sampleDocuments;

    private CreateTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.transformerId = builder.transformerId;
        this.transformerArn = builder.transformerArn;
        this.name = builder.name;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.inputConversion = builder.inputConversion;
        this.mapping = builder.mapping;
        this.outputConversion = builder.outputConversion;
        this.sampleDocuments = builder.sampleDocuments;
    }

    public final String transformerId() {
        return this.transformerId;
    }

    public final String transformerArn() {
        return this.transformerArn;
    }

    public final String name() {
        return this.name;
    }

    public final TransformerStatus status() {
        return TransformerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    @Deprecated
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    @Deprecated
    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    @Deprecated
    public final String mappingTemplate() {
        return this.mappingTemplate;
    }

    @Deprecated
    public final EdiType ediType() {
        return this.ediType;
    }

    @Deprecated
    public final String sampleDocument() {
        return this.sampleDocument;
    }

    public final InputConversion inputConversion() {
        return this.inputConversion;
    }

    public final Mapping mapping() {
        return this.mapping;
    }

    public final OutputConversion outputConversion() {
        return this.outputConversion;
    }

    public final SampleDocuments sampleDocuments() {
        return this.sampleDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.ediType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleDocuments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformerResponse)) {
            return false;
        }
        CreateTransformerResponse other = (CreateTransformerResponse)((Object)obj);
        return Objects.equals(this.transformerId(), other.transformerId()) && Objects.equals(this.transformerArn(), other.transformerArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.mappingTemplate(), other.mappingTemplate()) && Objects.equals(this.ediType(), other.ediType()) && Objects.equals(this.sampleDocument(), other.sampleDocument()) && Objects.equals(this.inputConversion(), other.inputConversion()) && Objects.equals(this.mapping(), other.mapping()) && Objects.equals(this.outputConversion(), other.outputConversion()) && Objects.equals(this.sampleDocuments(), other.sampleDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransformerResponse").add("TransformerId", (Object)this.transformerId()).add("TransformerArn", (Object)this.transformerArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("FileFormat", (Object)this.fileFormatAsString()).add("MappingTemplate", (Object)this.mappingTemplate()).add("EdiType", (Object)this.ediType()).add("SampleDocument", (Object)this.sampleDocument()).add("InputConversion", (Object)this.inputConversion()).add("Mapping", (Object)this.mapping()).add("OutputConversion", (Object)this.outputConversion()).add("SampleDocuments", (Object)this.sampleDocuments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformerId": {
                return Optional.ofNullable(clazz.cast(this.transformerId()));
            }
            case "transformerArn": {
                return Optional.ofNullable(clazz.cast(this.transformerArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "mappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.mappingTemplate()));
            }
            case "ediType": {
                return Optional.ofNullable(clazz.cast(this.ediType()));
            }
            case "sampleDocument": {
                return Optional.ofNullable(clazz.cast(this.sampleDocument()));
            }
            case "inputConversion": {
                return Optional.ofNullable(clazz.cast(this.inputConversion()));
            }
            case "mapping": {
                return Optional.ofNullable(clazz.cast(this.mapping()));
            }
            case "outputConversion": {
                return Optional.ofNullable(clazz.cast(this.outputConversion()));
            }
            case "sampleDocuments": {
                return Optional.ofNullable(clazz.cast(this.sampleDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transformerId", TRANSFORMER_ID_FIELD);
        map.put("transformerArn", TRANSFORMER_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("mappingTemplate", MAPPING_TEMPLATE_FIELD);
        map.put("ediType", EDI_TYPE_FIELD);
        map.put("sampleDocument", SAMPLE_DOCUMENT_FIELD);
        map.put("inputConversion", INPUT_CONVERSION_FIELD);
        map.put("mapping", MAPPING_FIELD);
        map.put("outputConversion", OUTPUT_CONVERSION_FIELD);
        map.put("sampleDocuments", SAMPLE_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformerResponse, T> g) {
        return obj -> g.apply((CreateTransformerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String transformerId;
        private String transformerArn;
        private String name;
        private String status;
        private Instant createdAt;
        private String fileFormat;
        private String mappingTemplate;
        private EdiType ediType;
        private String sampleDocument;
        private InputConversion inputConversion;
        private Mapping mapping;
        private OutputConversion outputConversion;
        private SampleDocuments sampleDocuments;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformerResponse model) {
            super(model);
            this.transformerId(model.transformerId);
            this.transformerArn(model.transformerArn);
            this.name(model.name);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.fileFormat(model.fileFormat);
            this.mappingTemplate(model.mappingTemplate);
            this.ediType(model.ediType);
            this.sampleDocument(model.sampleDocument);
            this.inputConversion(model.inputConversion);
            this.mapping(model.mapping);
            this.outputConversion(model.outputConversion);
            this.sampleDocuments(model.sampleDocuments);
        }

        public final String getTransformerId() {
            return this.transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public final String getTransformerArn() {
            return this.transformerArn;
        }

        public final void setTransformerArn(String transformerArn) {
            this.transformerArn = transformerArn;
        }

        @Override
        public final Builder transformerArn(String transformerArn) {
            this.transformerArn = transformerArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Deprecated
        public final String getFileFormat() {
            return this.fileFormat;
        }

        @Deprecated
        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        @Deprecated
        public final String getMappingTemplate() {
            return this.mappingTemplate;
        }

        @Deprecated
        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        @Deprecated
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        @Deprecated
        public final EdiType.Builder getEdiType() {
            return this.ediType != null ? this.ediType.toBuilder() : null;
        }

        @Deprecated
        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        @Deprecated
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        @Deprecated
        public final String getSampleDocument() {
            return this.sampleDocument;
        }

        @Deprecated
        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        @Deprecated
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final InputConversion.Builder getInputConversion() {
            return this.inputConversion != null ? this.inputConversion.toBuilder() : null;
        }

        public final void setInputConversion(InputConversion.BuilderImpl inputConversion) {
            this.inputConversion = inputConversion != null ? inputConversion.build() : null;
        }

        @Override
        public final Builder inputConversion(InputConversion inputConversion) {
            this.inputConversion = inputConversion;
            return this;
        }

        public final Mapping.Builder getMapping() {
            return this.mapping != null ? this.mapping.toBuilder() : null;
        }

        public final void setMapping(Mapping.BuilderImpl mapping) {
            this.mapping = mapping != null ? mapping.build() : null;
        }

        @Override
        public final Builder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public final OutputConversion.Builder getOutputConversion() {
            return this.outputConversion != null ? this.outputConversion.toBuilder() : null;
        }

        public final void setOutputConversion(OutputConversion.BuilderImpl outputConversion) {
            this.outputConversion = outputConversion != null ? outputConversion.build() : null;
        }

        @Override
        public final Builder outputConversion(OutputConversion outputConversion) {
            this.outputConversion = outputConversion;
            return this;
        }

        public final SampleDocuments.Builder getSampleDocuments() {
            return this.sampleDocuments != null ? this.sampleDocuments.toBuilder() : null;
        }

        public final void setSampleDocuments(SampleDocuments.BuilderImpl sampleDocuments) {
            this.sampleDocuments = sampleDocuments != null ? sampleDocuments.build() : null;
        }

        @Override
        public final Builder sampleDocuments(SampleDocuments sampleDocuments) {
            this.sampleDocuments = sampleDocuments;
            return this;
        }

        @Override
        public CreateTransformerResponse build() {
            return new CreateTransformerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransformerResponse> {
        public Builder transformerId(String var1);

        public Builder transformerArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(TransformerStatus var1);

        public Builder createdAt(Instant var1);

        @Deprecated
        public Builder fileFormat(String var1);

        @Deprecated
        public Builder fileFormat(FileFormat var1);

        @Deprecated
        public Builder mappingTemplate(String var1);

        @Deprecated
        public Builder ediType(EdiType var1);

        @Deprecated
        default public Builder ediType(Consumer<EdiType.Builder> ediType) {
            return this.ediType((EdiType)((EdiType.Builder)EdiType.builder().applyMutation(ediType)).build());
        }

        @Deprecated
        public Builder sampleDocument(String var1);

        public Builder inputConversion(InputConversion var1);

        default public Builder inputConversion(Consumer<InputConversion.Builder> inputConversion) {
            return this.inputConversion((InputConversion)((InputConversion.Builder)InputConversion.builder().applyMutation(inputConversion)).build());
        }

        public Builder mapping(Mapping var1);

        default public Builder mapping(Consumer<Mapping.Builder> mapping) {
            return this.mapping((Mapping)((Mapping.Builder)Mapping.builder().applyMutation(mapping)).build());
        }

        public Builder outputConversion(OutputConversion var1);

        default public Builder outputConversion(Consumer<OutputConversion.Builder> outputConversion) {
            return this.outputConversion((OutputConversion)((OutputConversion.Builder)OutputConversion.builder().applyMutation(outputConversion)).build());
        }

        public Builder sampleDocuments(SampleDocuments var1);

        default public Builder sampleDocuments(Consumer<SampleDocuments.Builder> sampleDocuments) {
            return this.sampleDocuments((SampleDocuments)((SampleDocuments.Builder)SampleDocuments.builder().applyMutation(sampleDocuments)).build());
        }
    }
}

