/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WrapFormat {
    SEGMENT("SEGMENT"),
    ONE_LINE("ONE_LINE"),
    LINE_LENGTH("LINE_LENGTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WrapFormat> VALUE_MAP;
    private final String value;

    private WrapFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WrapFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WrapFormat> knownValues() {
        EnumSet<WrapFormat> knownValues = EnumSet.allOf(WrapFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WrapFormat.class, WrapFormat::toString);
    }
}

