/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.b2bi.B2BiClient;
import software.amazon.awssdk.services.b2bi.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.waiters.B2BiWaiter;
import software.amazon.awssdk.services.b2bi.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultB2BiWaiter
implements B2BiWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final B2BiClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetTransformerJobResponse> transformerJobSucceededWaiter;

    private DefaultB2BiWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (B2BiClient)B2BiClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.transformerJobSucceededWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetTransformerJobResponse.class).acceptors(DefaultB2BiWaiter.transformerJobSucceededWaiterAcceptors())).overrideConfiguration(DefaultB2BiWaiter.transformerJobSucceededWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetTransformerJobResponse> waitUntilTransformerJobSucceeded(GetTransformerJobRequest getTransformerJobRequest) {
        return this.transformerJobSucceededWaiter.run(() -> this.client.getTransformerJob(this.applyWaitersUserAgent(getTransformerJobRequest)));
    }

    @Override
    public WaiterResponse<GetTransformerJobResponse> waitUntilTransformerJobSucceeded(GetTransformerJobRequest getTransformerJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.transformerJobSucceededWaiter.run(() -> this.client.getTransformerJob(this.applyWaitersUserAgent(getTransformerJobRequest)), DefaultB2BiWaiter.transformerJobSucceededWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetTransformerJobResponse>> transformerJobSucceededWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetTransformerJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetTransformerJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "succeeded");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration transformerJobSucceededWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(12);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static B2BiWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends B2BiRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((B2BiRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements B2BiWaiter.Builder {
        private B2BiClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public B2BiWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public B2BiWaiter.Builder client(B2BiClient client) {
            this.client = client;
            return this;
        }

        @Override
        public B2BiWaiter build() {
            return new DefaultB2BiWaiter(this);
        }
    }
}

