/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.GlobalSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGlobalSettingsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeGlobalSettingsResponse> {
    private static final SdkField<Map<String, String>> GLOBAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("GlobalSettings").getter(DescribeGlobalSettingsResponse.getter(DescribeGlobalSettingsResponse::globalSettings)).setter(DescribeGlobalSettingsResponse.setter(Builder::globalSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(DescribeGlobalSettingsResponse.getter(DescribeGlobalSettingsResponse::lastUpdateTime)).setter(DescribeGlobalSettingsResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_SETTINGS_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGlobalSettingsResponse.memberNameToFieldInitializer();
    private final Map<String, String> globalSettings;
    private final Instant lastUpdateTime;

    private DescribeGlobalSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.globalSettings = builder.globalSettings;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final boolean hasGlobalSettings() {
        return this.globalSettings != null && !(this.globalSettings instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> globalSettings() {
        return this.globalSettings;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSettings() ? this.globalSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalSettingsResponse)) {
            return false;
        }
        DescribeGlobalSettingsResponse other = (DescribeGlobalSettingsResponse)((Object)obj);
        return this.hasGlobalSettings() == other.hasGlobalSettings() && Objects.equals(this.globalSettings(), other.globalSettings()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGlobalSettingsResponse").add("GlobalSettings", this.hasGlobalSettings() ? this.globalSettings() : null).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalSettings": {
                return Optional.ofNullable(clazz.cast(this.globalSettings()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlobalSettings", GLOBAL_SETTINGS_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalSettingsResponse, T> g) {
        return obj -> g.apply((DescribeGlobalSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private Map<String, String> globalSettings = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalSettingsResponse model) {
            super(model);
            this.globalSettings(model.globalSettings);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final Map<String, String> getGlobalSettings() {
            if (this.globalSettings instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.globalSettings;
        }

        public final void setGlobalSettings(Map<String, String> globalSettings) {
            this.globalSettings = GlobalSettingsCopier.copy(globalSettings);
        }

        @Override
        public final Builder globalSettings(Map<String, String> globalSettings) {
            this.globalSettings = GlobalSettingsCopier.copy(globalSettings);
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public DescribeGlobalSettingsResponse build() {
            return new DescribeGlobalSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGlobalSettingsResponse> {
        public Builder globalSettings(Map<String, String> var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

