/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListScanJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListScanJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ScanJobSummary;

public class ListScanJobSummariesPublisher
implements SdkPublisher<ListScanJobSummariesResponse> {
    private final BackupAsyncClient client;
    private final ListScanJobSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScanJobSummariesPublisher(BackupAsyncClient client, ListScanJobSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScanJobSummariesPublisher(BackupAsyncClient client, ListScanJobSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScanJobSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScanJobSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScanJobSummary> scanJobSummaries() {
        Function<ListScanJobSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanJobSummaries() != null) {
                return response.scanJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScanJobSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScanJobSummariesResponseFetcher
    implements AsyncPageFetcher<ListScanJobSummariesResponse> {
        private ListScanJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListScanJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScanJobSummariesResponse> nextPage(ListScanJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListScanJobSummariesPublisher.this.client.listScanJobSummaries(ListScanJobSummariesPublisher.this.firstRequest);
            }
            return ListScanJobSummariesPublisher.this.client.listScanJobSummaries((ListScanJobSummariesRequest)((Object)ListScanJobSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

