/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGatewayRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<CreateGatewayRequest.Builder, CreateGatewayRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationKey").getter(getter(CreateGatewayRequest::activationKey))
            .setter(setter(Builder::activationKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()).build();

    private static final SdkField<String> GATEWAY_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayDisplayName").getter(getter(CreateGatewayRequest::gatewayDisplayName))
            .setter(setter(Builder::gatewayDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayDisplayName").build())
            .build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayType").getter(getter(CreateGatewayRequest::gatewayTypeAsString))
            .setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGatewayRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD,
            GATEWAY_DISPLAY_NAME_FIELD, GATEWAY_TYPE_FIELD, TAGS_FIELD));

    private final String activationKey;

    private final String gatewayDisplayName;

    private final String gatewayType;

    private final List<Tag> tags;

    private CreateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.gatewayDisplayName = builder.gatewayDisplayName;
        this.gatewayType = builder.gatewayType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The activation key of the created gateway.
     * </p>
     * 
     * @return The activation key of the created gateway.
     */
    public final String activationKey() {
        return activationKey;
    }

    /**
     * <p>
     * The display name of the created gateway.
     * </p>
     * 
     * @return The display name of the created gateway.
     */
    public final String gatewayDisplayName() {
        return gatewayDisplayName;
    }

    /**
     * <p>
     * The type of created gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayType} will
     * return {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayTypeAsString}.
     * </p>
     * 
     * @return The type of created gateway.
     * @see GatewayType
     */
    public final GatewayType gatewayType() {
        return GatewayType.fromValue(gatewayType);
    }

    /**
     * <p>
     * The type of created gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayType} will
     * return {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayTypeAsString}.
     * </p>
     * 
     * @return The type of created gateway.
     * @see GatewayType
     */
    public final String gatewayTypeAsString() {
        return gatewayType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest) obj;
        return Objects.equals(activationKey(), other.activationKey())
                && Objects.equals(gatewayDisplayName(), other.gatewayDisplayName())
                && Objects.equals(gatewayTypeAsString(), other.gatewayTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGatewayRequest").add("ActivationKey", activationKey())
                .add("GatewayDisplayName", gatewayDisplayName()).add("GatewayType", gatewayTypeAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationKey":
            return Optional.ofNullable(clazz.cast(activationKey()));
        case "GatewayDisplayName":
            return Optional.ofNullable(clazz.cast(gatewayDisplayName()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRequest, T> g) {
        return obj -> g.apply((CreateGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGatewayRequest> {
        /**
         * <p>
         * The activation key of the created gateway.
         * </p>
         * 
         * @param activationKey
         *        The activation key of the created gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationKey(String activationKey);

        /**
         * <p>
         * The display name of the created gateway.
         * </p>
         * 
         * @param gatewayDisplayName
         *        The display name of the created gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayDisplayName(String gatewayDisplayName);

        /**
         * <p>
         * The type of created gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of created gateway.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The type of created gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of created gateway.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder gatewayType(GatewayType gatewayType);

        /**
         * <p>
         * A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private String activationKey;

        private String gatewayDisplayName;

        private String gatewayType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRequest model) {
            super(model);
            activationKey(model.activationKey);
            gatewayDisplayName(model.gatewayDisplayName);
            gatewayType(model.gatewayType);
            tags(model.tags);
        }

        public final String getActivationKey() {
            return activationKey;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        @Override
        @Transient
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final String getGatewayDisplayName() {
            return gatewayDisplayName;
        }

        public final void setGatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
        }

        @Override
        @Transient
        public final Builder gatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
            return this;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        @Transient
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        @Override
        @Transient
        public final Builder gatewayType(GatewayType gatewayType) {
            this.gatewayType(gatewayType == null ? null : gatewayType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRequest build() {
            return new CreateGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
