/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGatewayRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<DeleteGatewayRequest.Builder, DeleteGatewayRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(DeleteGatewayRequest::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD));

    private final String gatewayArn;

    private DeleteGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway to delete.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGatewayRequest)) {
            return false;
        }
        DeleteGatewayRequest other = (DeleteGatewayRequest) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGatewayRequest").add("GatewayArn", gatewayArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteGatewayRequest, T> g) {
        return obj -> g.apply((DeleteGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGatewayRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway to delete.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private String gatewayArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGatewayRequest model) {
            super(model);
            gatewayArn(model.gatewayArn);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        @Transient
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGatewayRequest build() {
            return new DeleteGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
