/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.HypervisorState;
import software.amazon.awssdk.services.backupgateway.model.SyncMetadataStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HypervisorDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HypervisorDetails> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(HypervisorDetails.getter(HypervisorDetails::host)).setter(HypervisorDetails.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorArn").getter(HypervisorDetails.getter(HypervisorDetails::hypervisorArn)).setter(HypervisorDetails.setter(Builder::hypervisorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(HypervisorDetails.getter(HypervisorDetails::kmsKeyArn)).setter(HypervisorDetails.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_METADATA_SYNC_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulMetadataSyncTime").getter(HypervisorDetails.getter(HypervisorDetails::lastSuccessfulMetadataSyncTime)).setter(HypervisorDetails.setter(Builder::lastSuccessfulMetadataSyncTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulMetadataSyncTime").build()}).build();
    private static final SdkField<String> LATEST_METADATA_SYNC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestMetadataSyncStatus").getter(HypervisorDetails.getter(HypervisorDetails::latestMetadataSyncStatusAsString)).setter(HypervisorDetails.setter(Builder::latestMetadataSyncStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestMetadataSyncStatus").build()}).build();
    private static final SdkField<String> LATEST_METADATA_SYNC_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestMetadataSyncStatusMessage").getter(HypervisorDetails.getter(HypervisorDetails::latestMetadataSyncStatusMessage)).setter(HypervisorDetails.setter(Builder::latestMetadataSyncStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestMetadataSyncStatusMessage").build()}).build();
    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupArn").getter(HypervisorDetails.getter(HypervisorDetails::logGroupArn)).setter(HypervisorDetails.setter(Builder::logGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(HypervisorDetails.getter(HypervisorDetails::name)).setter(HypervisorDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(HypervisorDetails.getter(HypervisorDetails::stateAsString)).setter(HypervisorDetails.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, HYPERVISOR_ARN_FIELD, KMS_KEY_ARN_FIELD, LAST_SUCCESSFUL_METADATA_SYNC_TIME_FIELD, LATEST_METADATA_SYNC_STATUS_FIELD, LATEST_METADATA_SYNC_STATUS_MESSAGE_FIELD, LOG_GROUP_ARN_FIELD, NAME_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HypervisorDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String host;
    private final String hypervisorArn;
    private final String kmsKeyArn;
    private final Instant lastSuccessfulMetadataSyncTime;
    private final String latestMetadataSyncStatus;
    private final String latestMetadataSyncStatusMessage;
    private final String logGroupArn;
    private final String name;
    private final String state;

    private HypervisorDetails(BuilderImpl builder) {
        this.host = builder.host;
        this.hypervisorArn = builder.hypervisorArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastSuccessfulMetadataSyncTime = builder.lastSuccessfulMetadataSyncTime;
        this.latestMetadataSyncStatus = builder.latestMetadataSyncStatus;
        this.latestMetadataSyncStatusMessage = builder.latestMetadataSyncStatusMessage;
        this.logGroupArn = builder.logGroupArn;
        this.name = builder.name;
        this.state = builder.state;
    }

    public final String host() {
        return this.host;
    }

    public final String hypervisorArn() {
        return this.hypervisorArn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final Instant lastSuccessfulMetadataSyncTime() {
        return this.lastSuccessfulMetadataSyncTime;
    }

    public final SyncMetadataStatus latestMetadataSyncStatus() {
        return SyncMetadataStatus.fromValue(this.latestMetadataSyncStatus);
    }

    public final String latestMetadataSyncStatusAsString() {
        return this.latestMetadataSyncStatus;
    }

    public final String latestMetadataSyncStatusMessage() {
        return this.latestMetadataSyncStatusMessage;
    }

    public final String logGroupArn() {
        return this.logGroupArn;
    }

    public final String name() {
        return this.name;
    }

    public final HypervisorState state() {
        return HypervisorState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulMetadataSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestMetadataSyncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestMetadataSyncStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HypervisorDetails)) {
            return false;
        }
        HypervisorDetails other = (HypervisorDetails)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.hypervisorArn(), other.hypervisorArn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.lastSuccessfulMetadataSyncTime(), other.lastSuccessfulMetadataSyncTime()) && Objects.equals(this.latestMetadataSyncStatusAsString(), other.latestMetadataSyncStatusAsString()) && Objects.equals(this.latestMetadataSyncStatusMessage(), other.latestMetadataSyncStatusMessage()) && Objects.equals(this.logGroupArn(), other.logGroupArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HypervisorDetails").add("Host", (Object)this.host()).add("HypervisorArn", (Object)this.hypervisorArn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("LastSuccessfulMetadataSyncTime", (Object)this.lastSuccessfulMetadataSyncTime()).add("LatestMetadataSyncStatus", (Object)this.latestMetadataSyncStatusAsString()).add("LatestMetadataSyncStatusMessage", (Object)this.latestMetadataSyncStatusMessage()).add("LogGroupArn", (Object)this.logGroupArn()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "HypervisorArn": {
                return Optional.ofNullable(clazz.cast(this.hypervisorArn()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "LastSuccessfulMetadataSyncTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulMetadataSyncTime()));
            }
            case "LatestMetadataSyncStatus": {
                return Optional.ofNullable(clazz.cast(this.latestMetadataSyncStatusAsString()));
            }
            case "LatestMetadataSyncStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.latestMetadataSyncStatusMessage()));
            }
            case "LogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.logGroupArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Host", HOST_FIELD);
        map.put("HypervisorArn", HYPERVISOR_ARN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("LastSuccessfulMetadataSyncTime", LAST_SUCCESSFUL_METADATA_SYNC_TIME_FIELD);
        map.put("LatestMetadataSyncStatus", LATEST_METADATA_SYNC_STATUS_FIELD);
        map.put("LatestMetadataSyncStatusMessage", LATEST_METADATA_SYNC_STATUS_MESSAGE_FIELD);
        map.put("LogGroupArn", LOG_GROUP_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HypervisorDetails, T> g) {
        return obj -> g.apply((HypervisorDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private String hypervisorArn;
        private String kmsKeyArn;
        private Instant lastSuccessfulMetadataSyncTime;
        private String latestMetadataSyncStatus;
        private String latestMetadataSyncStatusMessage;
        private String logGroupArn;
        private String name;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(HypervisorDetails model) {
            this.host(model.host);
            this.hypervisorArn(model.hypervisorArn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.lastSuccessfulMetadataSyncTime(model.lastSuccessfulMetadataSyncTime);
            this.latestMetadataSyncStatus(model.latestMetadataSyncStatus);
            this.latestMetadataSyncStatusMessage(model.latestMetadataSyncStatusMessage);
            this.logGroupArn(model.logGroupArn);
            this.name(model.name);
            this.state(model.state);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getHypervisorArn() {
            return this.hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getLastSuccessfulMetadataSyncTime() {
            return this.lastSuccessfulMetadataSyncTime;
        }

        public final void setLastSuccessfulMetadataSyncTime(Instant lastSuccessfulMetadataSyncTime) {
            this.lastSuccessfulMetadataSyncTime = lastSuccessfulMetadataSyncTime;
        }

        @Override
        public final Builder lastSuccessfulMetadataSyncTime(Instant lastSuccessfulMetadataSyncTime) {
            this.lastSuccessfulMetadataSyncTime = lastSuccessfulMetadataSyncTime;
            return this;
        }

        public final String getLatestMetadataSyncStatus() {
            return this.latestMetadataSyncStatus;
        }

        public final void setLatestMetadataSyncStatus(String latestMetadataSyncStatus) {
            this.latestMetadataSyncStatus = latestMetadataSyncStatus;
        }

        @Override
        public final Builder latestMetadataSyncStatus(String latestMetadataSyncStatus) {
            this.latestMetadataSyncStatus = latestMetadataSyncStatus;
            return this;
        }

        @Override
        public final Builder latestMetadataSyncStatus(SyncMetadataStatus latestMetadataSyncStatus) {
            this.latestMetadataSyncStatus(latestMetadataSyncStatus == null ? null : latestMetadataSyncStatus.toString());
            return this;
        }

        public final String getLatestMetadataSyncStatusMessage() {
            return this.latestMetadataSyncStatusMessage;
        }

        public final void setLatestMetadataSyncStatusMessage(String latestMetadataSyncStatusMessage) {
            this.latestMetadataSyncStatusMessage = latestMetadataSyncStatusMessage;
        }

        @Override
        public final Builder latestMetadataSyncStatusMessage(String latestMetadataSyncStatusMessage) {
            this.latestMetadataSyncStatusMessage = latestMetadataSyncStatusMessage;
            return this;
        }

        public final String getLogGroupArn() {
            return this.logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HypervisorState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public HypervisorDetails build() {
            return new HypervisorDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HypervisorDetails> {
        public Builder host(String var1);

        public Builder hypervisorArn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder lastSuccessfulMetadataSyncTime(Instant var1);

        public Builder latestMetadataSyncStatus(String var1);

        public Builder latestMetadataSyncStatus(SyncMetadataStatus var1);

        public Builder latestMetadataSyncStatusMessage(String var1);

        public Builder logGroupArn(String var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(HypervisorState var1);
    }
}

