/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupgateway.BackupGatewayClient;
import software.amazon.awssdk.services.backupgateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse;
import software.amazon.awssdk.services.backupgateway.model.VirtualMachine;

public class ListVirtualMachinesIterable
implements SdkIterable<ListVirtualMachinesResponse> {
    private final BackupGatewayClient client;
    private final ListVirtualMachinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualMachinesIterable(BackupGatewayClient client, ListVirtualMachinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVirtualMachinesResponseFetcher();
    }

    public Iterator<ListVirtualMachinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualMachine> virtualMachines() {
        Function<ListVirtualMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualMachines() != null) {
                return response.virtualMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVirtualMachinesResponseFetcher
    implements SyncPageFetcher<ListVirtualMachinesResponse> {
        private ListVirtualMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVirtualMachinesResponse nextPage(ListVirtualMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMachinesIterable.this.client.listVirtualMachines(ListVirtualMachinesIterable.this.firstRequest);
            }
            return ListVirtualMachinesIterable.this.client.listVirtualMachines((ListVirtualMachinesRequest)((Object)ListVirtualMachinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

